/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIMessages;
import javax.faces.component.html.HtmlMessages;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.renderkit.RendererUtils;
import org.apache.myfaces.renderkit.html.HtmlMessageRendererBase;
import org.apache.myfaces.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.util.NullIterator;

public abstract class HtmlMessagesRendererBase
extends HtmlMessageRendererBase {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$renderkit$html$HtmlMessagesRendererBase == null ? (class$org$apache$myfaces$renderkit$html$HtmlMessagesRendererBase = HtmlMessagesRendererBase.class$("org.apache.myfaces.renderkit.html.HtmlMessagesRendererBase")) : class$org$apache$myfaces$renderkit$html$HtmlMessagesRendererBase));
    protected static final String LAYOUT_LIST = "list";
    protected static final String LAYOUT_TABLE = "table";
    static /* synthetic */ Class class$org$apache$myfaces$renderkit$html$HtmlMessagesRendererBase;

    protected void renderMessages(FacesContext facesContext, UIComponent messages) throws IOException {
        MessagesIterator messagesIterator = new MessagesIterator(facesContext, this.isGlobalOnly(messages));
        if (messagesIterator.hasNext()) {
            String layout = this.getLayout(messages);
            if (layout == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No messages layout given, using default layout 'list'.");
                }
                this.renderList(facesContext, messages, messagesIterator);
            } else if (layout.equalsIgnoreCase(LAYOUT_TABLE)) {
                this.renderTable(facesContext, messages, messagesIterator);
            } else {
                if (log.isWarnEnabled() && !layout.equalsIgnoreCase(LAYOUT_LIST)) {
                    log.warn((Object)("Unsupported messages layout '" + layout + "' - using default layout 'list'."));
                }
                this.renderList(facesContext, messages, messagesIterator);
            }
        }
    }

    private void renderList(FacesContext facesContext, UIComponent messages, MessagesIterator messagesIterator) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("ul", messages);
        HtmlRendererUtils.writeIdIfNecessary(writer, messages, facesContext);
        while (messagesIterator.hasNext()) {
            writer.startElement("li", messages);
            this.renderSingleFacesMessage(facesContext, messages, (FacesMessage)messagesIterator.next(), messagesIterator.getClientId());
            writer.endElement("li");
        }
        writer.endElement("ul");
    }

    private void renderTable(FacesContext facesContext, UIComponent messages, MessagesIterator messagesIterator) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement(LAYOUT_TABLE, messages);
        HtmlRendererUtils.writeIdIfNecessary(writer, messages, facesContext);
        while (messagesIterator.hasNext()) {
            writer.startElement("tr", messages);
            writer.startElement("td", messages);
            this.renderSingleFacesMessage(facesContext, messages, (FacesMessage)messagesIterator.next(), messagesIterator.getClientId());
            writer.endElement("td");
            writer.endElement("tr");
        }
        writer.endElement(LAYOUT_TABLE);
    }

    protected String[] getStyleAndStyleClass(UIComponent messages, FacesMessage.Severity severity) {
        String style = null;
        String styleClass = null;
        if (messages instanceof HtmlMessages) {
            if (severity == FacesMessage.SEVERITY_INFO) {
                style = ((HtmlMessages)messages).getInfoStyle();
                styleClass = ((HtmlMessages)messages).getInfoClass();
            } else if (severity == FacesMessage.SEVERITY_WARN) {
                style = ((HtmlMessages)messages).getWarnStyle();
                styleClass = ((HtmlMessages)messages).getWarnClass();
            } else if (severity == FacesMessage.SEVERITY_ERROR) {
                style = ((HtmlMessages)messages).getErrorStyle();
                styleClass = ((HtmlMessages)messages).getErrorClass();
            } else if (severity == FacesMessage.SEVERITY_FATAL) {
                style = ((HtmlMessages)messages).getFatalStyle();
                styleClass = ((HtmlMessages)messages).getFatalClass();
            }
            if (style == null) {
                style = ((HtmlMessages)messages).getStyle();
            }
            if (styleClass == null) {
                styleClass = ((HtmlMessages)messages).getStyleClass();
            }
        } else {
            Map attr = messages.getAttributes();
            if (severity == FacesMessage.SEVERITY_INFO) {
                style = (String)attr.get("infoStyle");
                styleClass = (String)attr.get("infoClass");
            } else if (severity == FacesMessage.SEVERITY_WARN) {
                style = (String)attr.get("warnStyle");
                styleClass = (String)attr.get("warnClass");
            } else if (severity == FacesMessage.SEVERITY_ERROR) {
                style = (String)attr.get("errorStyle");
                styleClass = (String)attr.get("errorClass");
            } else if (severity == FacesMessage.SEVERITY_FATAL) {
                style = (String)attr.get("fatalStyle");
                styleClass = (String)attr.get("fatalClass");
            }
            if (style == null) {
                style = (String)attr.get("styleClass");
            }
            if (styleClass == null) {
                styleClass = (String)attr.get("styleClass");
            }
        }
        return new String[]{style, styleClass};
    }

    protected String getTitle(UIComponent component) {
        if (component instanceof HtmlMessages) {
            return ((HtmlMessages)component).getTitle();
        }
        return (String)component.getAttributes().get("title");
    }

    protected boolean isTooltip(UIComponent component) {
        if (component instanceof HtmlMessages) {
            return ((HtmlMessages)component).isTooltip();
        }
        return RendererUtils.getBooleanAttribute(component, "tooltip", false);
    }

    protected boolean isShowSummary(UIComponent component) {
        if (component instanceof UIMessages) {
            return ((UIMessages)component).isShowSummary();
        }
        return RendererUtils.getBooleanAttribute(component, "showSummary", false);
    }

    protected boolean isShowDetail(UIComponent component) {
        if (component instanceof UIMessages) {
            return ((UIMessages)component).isShowDetail();
        }
        return RendererUtils.getBooleanAttribute(component, "showDetail", false);
    }

    protected boolean isGlobalOnly(UIComponent component) {
        if (component instanceof UIMessages) {
            return ((UIMessages)component).isGlobalOnly();
        }
        return RendererUtils.getBooleanAttribute(component, "globalOnly", false);
    }

    protected String getLayout(UIComponent component) {
        if (component instanceof HtmlMessages) {
            return ((HtmlMessages)component).getLayout();
        }
        return (String)component.getAttributes().get("layout");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class MessagesIterator
    implements Iterator {
        private FacesContext _facesContext;
        private Iterator _globalMessagesIterator;
        private Iterator _clientIdsWithMessagesIterator;
        private Iterator _componentMessagesIterator = null;
        private String _clientId = null;

        public MessagesIterator(FacesContext facesContext, boolean globalOnly) {
            this._facesContext = facesContext;
            this._globalMessagesIterator = facesContext.getMessages(null);
            this._clientIdsWithMessagesIterator = globalOnly ? NullIterator.instance() : facesContext.getClientIdsWithMessages();
            this._componentMessagesIterator = null;
            this._clientId = null;
        }

        public boolean hasNext() {
            return this._globalMessagesIterator.hasNext() || this._clientIdsWithMessagesIterator.hasNext() || this._componentMessagesIterator != null && this._componentMessagesIterator.hasNext();
        }

        public Object next() {
            if (this._globalMessagesIterator.hasNext()) {
                return this._globalMessagesIterator.next();
            }
            if (this._componentMessagesIterator != null && this._componentMessagesIterator.hasNext()) {
                return this._componentMessagesIterator.next();
            }
            this._clientId = (String)this._clientIdsWithMessagesIterator.next();
            this._componentMessagesIterator = this._facesContext.getMessages(this._clientId);
            return this._componentMessagesIterator.next();
        }

        public void remove() {
            throw new UnsupportedOperationException(this.getClass().getName() + " UnsupportedOperationException");
        }

        public String getClientId() {
            return this._clientId;
        }
    }
}

