/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.unit;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.seasar.extension.dataset.ColumnType;
import org.seasar.extension.dataset.DataRow;
import org.seasar.extension.dataset.DataSet;
import org.seasar.extension.dataset.DataTable;
import org.seasar.extension.dataset.impl.SqlDeleteTableWriter;
import org.seasar.extension.dataset.impl.SqlReloadReader;
import org.seasar.extension.dataset.impl.SqlReloadTableReader;
import org.seasar.extension.dataset.impl.SqlTableReader;
import org.seasar.extension.dataset.impl.SqlWriter;
import org.seasar.extension.dataset.impl.XlsReader;
import org.seasar.extension.dataset.impl.XlsWriter;
import org.seasar.extension.dataset.types.ColumnTypes;
import org.seasar.extension.jdbc.impl.BasicUpdateHandler;
import org.seasar.extension.mock.servlet.MockHttpServletRequest;
import org.seasar.extension.mock.servlet.MockHttpServletResponse;
import org.seasar.extension.mock.servlet.MockHttpServletResponseImpl;
import org.seasar.extension.mock.servlet.MockServlet;
import org.seasar.extension.mock.servlet.MockServletConfig;
import org.seasar.extension.mock.servlet.MockServletConfigImpl;
import org.seasar.extension.mock.servlet.MockServletContext;
import org.seasar.extension.mock.servlet.MockServletContextImpl;
import org.seasar.extension.unit.BeanListReader;
import org.seasar.extension.unit.BeanReader;
import org.seasar.extension.unit.MapListReader;
import org.seasar.extension.unit.MapReader;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.S2ContainerFactory;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.container.impl.S2ContainerImpl;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.framework.exception.NoSuchMethodRuntimeException;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.ConnectionUtil;
import org.seasar.framework.util.DataSourceUtil;
import org.seasar.framework.util.FieldUtil;
import org.seasar.framework.util.FileOutputStreamUtil;
import org.seasar.framework.util.MethodUtil;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.StringUtil;

public class S2TestCase
extends TestCase {
    private static final String DATASOURCE_NAME = "j2ee.dataSource";
    private S2Container container_;
    private Servlet servlet_;
    private MockServletConfig servletConfig_;
    private MockServletContext servletContext_;
    private MockHttpServletRequest request_;
    private MockHttpServletResponse response_;
    private DataSource dataSource_;
    private Connection connection_;
    private DatabaseMetaData dbMetaData_;
    private List bindedFields_;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public S2TestCase() {
    }

    public S2TestCase(String name) {
        super(name);
    }

    public S2Container getContainer() {
        return this.container_;
    }

    public Object getComponent(String componentName) {
        return this.container_.getComponent((Object)componentName);
    }

    public Object getComponent(Class componentClass) {
        return this.container_.getComponent((Object)componentClass);
    }

    public ComponentDef getComponentDef(String componentName) {
        return this.container_.getComponentDef((Object)componentName);
    }

    public ComponentDef getComponentDef(Class componentClass) {
        return this.container_.getComponentDef((Object)componentClass);
    }

    public void register(Class componentClass) {
        this.container_.register(componentClass);
    }

    public void register(Class componentClass, String componentName) {
        this.container_.register(componentClass, componentName);
    }

    public void register(Object component) {
        this.container_.register(component);
    }

    public void register(Object component, String componentName) {
        this.container_.register(component, componentName);
    }

    public void register(ComponentDef componentDef) {
        this.container_.register(componentDef);
    }

    public void include(String path) {
        S2ContainerFactory.include((S2Container)this.container_, (String)this.convertPath(path));
    }

    private String convertPath(String path) {
        if (ResourceUtil.getResourceNoException((String)path) != null) {
            return path;
        }
        String prefix = ((Object)((Object)this)).getClass().getPackage().getName().replace('.', '/');
        return String.valueOf(prefix) + "/" + path;
    }

    public DataSource getDataSource() {
        if (this.dataSource_ == null) {
            throw new EmptyRuntimeException("dataSource");
        }
        return this.dataSource_;
    }

    public Connection getConnection() {
        if (this.connection_ != null) {
            return this.connection_;
        }
        this.connection_ = DataSourceUtil.getConnection((DataSource)this.getDataSource());
        return this.connection_;
    }

    public DatabaseMetaData getDatabaseMetaData() {
        if (this.dbMetaData_ != null) {
            return this.dbMetaData_;
        }
        this.dbMetaData_ = ConnectionUtil.getMetaData((Connection)this.getConnection());
        return this.dbMetaData_;
    }

    public DataSet readXls(String path) {
        XlsReader reader = new XlsReader(this.convertPath(path));
        return reader.read();
    }

    public void writeXls(String path, DataSet dataSet) {
        File dir = ResourceUtil.getBuildDir(((Object)((Object)this)).getClass());
        File file = new File(dir, this.convertPath(path));
        XlsWriter writer = new XlsWriter(FileOutputStreamUtil.create((File)file));
        writer.write(dataSet);
    }

    public void writeDb(DataSet dataSet) {
        SqlWriter writer = new SqlWriter(this.getDataSource());
        writer.write(dataSet);
    }

    public DataTable readDbByTable(String table) {
        return this.readDbByTable(table, null);
    }

    public DataTable readDbByTable(String table, String condition) {
        SqlTableReader reader = new SqlTableReader(this.getDataSource());
        reader.setTable(table, condition);
        return reader.read();
    }

    public DataTable readDbBySql(String sql, String tableName) {
        SqlTableReader reader = new SqlTableReader(this.getDataSource());
        reader.setSql(sql, tableName);
        return reader.read();
    }

    public void readXlsWriteDb(String path) {
        this.writeDb(this.readXls(path));
    }

    public void readXlsReplaceDb(String path) {
        DataSet dataSet = this.readXls(path);
        this.deleteDb(dataSet);
        this.writeDb(dataSet);
    }

    public void readXlsAllReplaceDb(String path) {
        DataSet dataSet = this.readXls(path);
        int i = dataSet.getTableSize() - 1;
        while (i >= 0) {
            this.deleteTable(dataSet.getTable(i).getTableName());
            --i;
        }
        this.writeDb(dataSet);
    }

    public DataSet reload(DataSet dataSet) {
        return new SqlReloadReader(this.getDataSource(), dataSet).read();
    }

    public DataTable reload(DataTable table) {
        return new SqlReloadTableReader(this.getDataSource(), table).read();
    }

    public void deleteDb(DataSet dataSet) {
        SqlDeleteTableWriter writer = new SqlDeleteTableWriter(this.getDataSource());
        int i = dataSet.getTableSize() - 1;
        while (i >= 0) {
            writer.write(dataSet.getTable(i));
            --i;
        }
    }

    public void deleteTable(String tableName) {
        BasicUpdateHandler handler = new BasicUpdateHandler(this.getDataSource(), "DELETE FROM " + tableName);
        handler.execute(null);
    }

    public void assertEquals(DataSet expected, DataSet actual) {
        this.assertEquals(null, expected, actual);
    }

    public void assertEquals(String message, DataSet expected, DataSet actual) {
        message = message == null ? "" : message;
        Assert.assertEquals((String)(String.valueOf(message) + ":TableSize"), (int)expected.getTableSize(), (int)actual.getTableSize());
        int i = 0;
        while (i < expected.getTableSize()) {
            this.assertEquals(message, expected.getTable(i), actual.getTable(i));
            ++i;
        }
    }

    public void assertEquals(DataTable expected, DataTable actual) {
        this.assertEquals(null, expected, actual);
    }

    public void assertEquals(String message, DataTable expected, DataTable actual) {
        message = message == null ? "" : message;
        Assert.assertEquals((String)(String.valueOf(message) + ":RowSize"), (int)expected.getRowSize(), (int)actual.getRowSize());
        int i = 0;
        while (i < expected.getRowSize()) {
            DataRow expectedRow = expected.getRow(i);
            DataRow actualRow = actual.getRow(i);
            int j = 0;
            while (j < expected.getColumnSize()) {
                Object actualValue;
                String columnName = expected.getColumnName(j);
                Object expectedValue = expectedRow.getValue(columnName);
                ColumnType ct = ColumnTypes.getColumnType(expectedValue);
                if (!ct.equals(expectedValue, actualValue = actualRow.getValue(columnName))) {
                    Assert.assertEquals((String)(String.valueOf(message) + ":Row=" + i + ":columnName=" + columnName), (Object)expectedValue, (Object)actualValue);
                }
                ++j;
            }
            ++i;
        }
    }

    public void assertEquals(DataSet expected, Object actual) {
        this.assertEquals(null, expected, actual);
    }

    public void assertEquals(String message, DataSet expected, Object actual) {
        if (expected == null || actual == null) {
            Assert.assertEquals((String)message, (Object)expected, (Object)actual);
            return;
        }
        if (actual instanceof List) {
            List actualList = (List)actual;
            Assert.assertFalse((boolean)actualList.isEmpty());
            Object actualItem = actualList.get(0);
            if (actualItem instanceof Map) {
                this.assertMapListEquals(message, expected, actualList);
            } else {
                this.assertBeanListEquals(message, expected, actualList);
            }
        } else if (actual instanceof Object[]) {
            this.assertEquals(message, expected, Arrays.asList((Object[])actual));
        } else if (actual instanceof Map) {
            this.assertMapEquals(message, expected, (Map)actual);
        } else {
            this.assertBeanEquals(message, expected, actual);
        }
    }

    protected void assertMapEquals(String message, DataSet expected, Map map) {
        MapReader reader = new MapReader(map);
        this.assertEquals(message, expected, reader.read());
    }

    protected void assertMapListEquals(String message, DataSet expected, List list) {
        MapListReader reader = new MapListReader(list);
        this.assertEquals(message, expected, reader.read());
    }

    protected void assertBeanEquals(String message, DataSet expected, Object bean) {
        BeanReader reader = new BeanReader(bean);
        this.assertEquals(message, expected, reader.read());
    }

    protected void assertBeanListEquals(String message, DataSet expected, List list) {
        BeanListReader reader = new BeanListReader(list);
        this.assertEquals(message, expected, reader.read());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runBare() throws Throwable {
        this.setUpContainer();
        this.setUp();
        try {
            this.setUpForEachTestMethod();
            try {
                this.container_.init();
                try {
                    this.setupDataSource();
                    try {
                        this.setUpAfterContainerInit();
                        this.bindFields();
                        this.setUpAfterBindFields();
                        try {
                            this.runTestTx();
                        }
                        catch (Throwable var2_1) {
                            var1_2 = null;
                            this.tearDownBeforeUnbindFields();
                            this.unbindFields();
                            throw var2_1;
                        }
                        {
                            var1_3 = null;
                        }
                        this.tearDownBeforeUnbindFields();
                        this.unbindFields();
                        this.tearDownBeforeContainerDestroy();
                    }
                    catch (Throwable var4_4) {
                        var3_5 = null;
                        this.tearDownDataSource();
                        throw var4_4;
                    }
                    {
                        var3_6 = null;
                        this.tearDownDataSource();
                    }
                }
                catch (Throwable var6_7) {
                    var5_8 = null;
                    this.tearDownContainer();
                    throw var6_7;
                }
                {
                    var5_9 = null;
                    this.tearDownContainer();
                }
            }
            catch (Throwable var8_10) {
                var7_11 = null;
                this.tearDownForEachTestMethod();
                throw var8_10;
            }
            {
                var7_12 = null;
                this.tearDownForEachTestMethod();
                ** GOTO lbl-1000
            }
        }
        catch (Throwable var10_13) {
            var9_14 = null;
            i = 0;
        }
        while (true) {
            if (i >= 5) {
                this.tearDown();
                throw var10_13;
            }
            System.runFinalization();
            System.gc();
            ++i;
        }
lbl-1000:
        // 1 sources

        {
            var9_15 = null;
            i = 0;
        }
        while (true) {
            if (i >= 5) {
                this.tearDown();
                return;
            }
            System.runFinalization();
            System.gc();
            ++i;
        }
    }

    protected void setUpContainer() throws Throwable {
        this.container_ = new S2ContainerImpl();
        this.servletContext_ = new MockServletContextImpl("s2jsf-example");
        this.request_ = this.servletContext_.createRequest("/hello.html");
        this.response_ = new MockHttpServletResponseImpl(this.request_);
        this.servletConfig_ = new MockServletConfigImpl();
        this.servletConfig_.setServletContext(this.servletContext_);
        this.servlet_ = new MockServlet();
        this.servlet_.init((ServletConfig)this.servletConfig_);
        this.container_.setServletContext((ServletContext)this.servletContext_);
        this.container_.setRequest((HttpServletRequest)this.request_);
        this.container_.setResponse((HttpServletResponse)this.response_);
        SingletonS2ContainerFactory.setContainer((S2Container)this.container_);
    }

    protected void tearDownContainer() throws Throwable {
        this.container_.destroy();
        SingletonS2ContainerFactory.setContainer(null);
        this.container_ = null;
        this.servletContext_ = null;
        this.request_ = null;
        this.response_ = null;
        this.servletConfig_ = null;
        this.servlet_ = null;
    }

    protected void setUpAfterContainerInit() throws Throwable {
    }

    protected void setUpAfterBindFields() throws Throwable {
    }

    protected void tearDownBeforeUnbindFields() throws Throwable {
    }

    protected void setUpForEachTestMethod() throws Throwable {
        this.invoke("setUp" + this.getTargetName());
    }

    protected void tearDownBeforeContainerDestroy() throws Throwable {
    }

    protected void tearDownForEachTestMethod() throws Throwable {
        this.invoke("tearDown" + this.getTargetName());
    }

    protected Servlet getServlet() {
        return this.servlet_;
    }

    protected void setServlet(Servlet servlet) {
        this.servlet_ = servlet;
    }

    protected MockServletConfig getServletConfig() {
        return this.servletConfig_;
    }

    protected void setServletConfig(MockServletConfig servletConfig) {
        this.servletConfig_ = servletConfig;
    }

    protected MockServletContext getServletContext() {
        return this.servletContext_;
    }

    protected void setServletContext(MockServletContext servletContext) {
        this.servletContext_ = servletContext;
    }

    protected MockHttpServletRequest getRequest() {
        return this.request_;
    }

    protected void setRequest(MockHttpServletRequest request) {
        this.request_ = request;
    }

    protected MockHttpServletResponse getResponse() {
        return this.response_;
    }

    protected void setResponse(MockHttpServletResponse response) {
        this.response_ = response;
    }

    private String getTargetName() {
        return this.getName().substring(4);
    }

    private void invoke(String methodName) throws Throwable {
        try {
            Method method = ClassUtil.getMethod(((Object)((Object)this)).getClass(), (String)methodName, null);
            MethodUtil.invoke((Method)method, (Object)((Object)this), null);
        }
        catch (NoSuchMethodRuntimeException noSuchMethodRuntimeException) {
            // empty catch block
        }
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void bindFields() throws Throwable {
        Class<?> clazz;
        this.bindedFields_ = new ArrayList();
        Class<?> clazz2 = ((Object)((Object)this)).getClass();
        boolean bl = true;
        do {
            if (!bl || (bl = false) || !true) {
                Field[] fields = clazz2.getDeclaredFields();
                int i = 0;
                while (i < fields.length) {
                    this.bindField(fields[i]);
                    ++i;
                }
                clazz2 = clazz2.getSuperclass();
            }
            if ((clazz = class$0) != null) continue;
            try {
                clazz = Class.forName("org.seasar.extension.unit.S2TestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        } while (clazz2 != clazz && clazz2 != null);
    }

    private void bindField(Field field) {
        if (this.isAutoBindable(field)) {
            field.setAccessible(true);
            if (FieldUtil.get((Field)field, (Object)((Object)this)) != null) {
                return;
            }
            String name = this.normalizeName(field.getName());
            Object component = null;
            if (this.getContainer().hasComponentDef((Object)name)) {
                Class<?> componentClass = this.getComponentDef(name).getComponentClass();
                if (componentClass == null && (component = this.getComponent(name)) != null) {
                    componentClass = component.getClass();
                }
                if (componentClass != null && field.getType().isAssignableFrom(componentClass)) {
                    if (component == null) {
                        component = this.getComponent(name);
                    }
                } else {
                    component = null;
                }
            }
            if (component == null && this.getContainer().hasComponentDef(field.getType())) {
                component = this.getComponent(field.getType());
            }
            if (component != null) {
                FieldUtil.set((Field)field, (Object)((Object)this), component);
                this.bindedFields_.add(field);
            }
        }
    }

    private String normalizeName(String name) {
        return StringUtil.replace((String)name, (String)"_", (String)"");
    }

    private boolean isAutoBindable(Field field) {
        int modifiers = field.getModifiers();
        return !Modifier.isStatic(modifiers) && !Modifier.isFinal(modifiers) && !field.getType().isPrimitive();
    }

    private void unbindFields() {
        int i = 0;
        while (i < this.bindedFields_.size()) {
            Field field = (Field)this.bindedFields_.get(i);
            try {
                field.set((Object)this, null);
            }
            catch (IllegalArgumentException e) {
                System.err.println(e);
            }
            catch (IllegalAccessException e) {
                System.err.println(e);
            }
            ++i;
        }
    }

    /*
     * Exception decompiling
     */
    private void runTestTx() throws Throwable {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 93->97)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean needTransaction() {
        return this.getName().endsWith("Tx");
    }

    private void setupDataSource() {
        block9: {
            try {
                if (this.container_.hasComponentDef((Object)DATASOURCE_NAME)) {
                    this.dataSource_ = (DataSource)this.container_.getComponent((Object)DATASOURCE_NAME);
                    break block9;
                }
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("javax.sql.DataSource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!this.container_.hasComponentDef((Object)clazz)) break block9;
                Class<?> clazz2 = class$2;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$2 = Class.forName("javax.sql.DataSource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this.dataSource_ = (DataSource)this.container_.getComponent((Object)clazz2);
            }
            catch (Throwable t) {
                System.err.println(t);
            }
        }
    }

    private void tearDownDataSource() {
        this.dbMetaData_ = null;
        if (this.connection_ != null) {
            ConnectionUtil.close((Connection)this.connection_);
            this.connection_ = null;
        }
        this.dataSource_ = null;
    }
}

