/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.jsf.runtime;

import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLFilterImpl;

public class TextuallyXMLFilter
extends XMLFilterImpl
implements LexicalHandler {
    protected int inEntity;

    public TextuallyXMLFilter(XMLReader parent) throws SAXNotRecognizedException, SAXNotSupportedException {
        super(parent);
        this.setProperty("http://xml.org/sax/properties/lexical-handler", this);
        this.setFeature("http://apache.org/xml/features/scanner/notify-char-refs", true);
        this.setFeature("http://cyberneko.org/html/features/scanner/notify-builtin-refs", true);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.inEntity == 0) {
            super.characters(ch, start, length);
        }
    }

    public void startEntity(String name) throws SAXException {
        String entityRef = "&" + name + ";";
        super.characters(entityRef.toCharArray(), 0, entityRef.length());
        ++this.inEntity;
    }

    public void endEntity(String name) throws SAXException {
        --this.inEntity;
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        StringBuffer buf = new StringBuffer(128);
        buf.append("<!DOCTYPE ").append(name);
        if (publicId != null) {
            buf.append(" PUBLIC \"").append(publicId).append("\"");
        }
        if (systemId != null) {
            if (publicId == null) {
                buf.append(" SYSTEM");
            }
            buf.append(" \"").append(systemId).append("\"");
        }
        buf.append(">\n");
        String docTypeDecl = new String(buf);
        super.characters(docTypeDecl.toCharArray(), 0, docTypeDecl.length());
    }

    public void endDTD() throws SAXException {
    }

    public void startCDATA() throws SAXException {
    }

    public void endCDATA() throws SAXException {
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        StringBuffer buf = new StringBuffer(length + 7);
        buf.append("<!--").append(ch, start, length).append("-->");
        String comment = new String(buf);
        super.characters(comment.toCharArray(), 0, comment.length());
    }
}

