/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.util.ArrayList;
import javax.sql.DataSource;
import org.seasar.dao.BeanMetaData;
import org.seasar.dao.NotSingleRowUpdatedRuntimeException;
import org.seasar.dao.PrimaryKeyNotFoundRuntimeException;
import org.seasar.dao.impl.AbstractAutoHandler;
import org.seasar.dao.impl.AbstractStaticCommand;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.extension.jdbc.StatementFactory;

public abstract class AbstractAutoStaticCommand
extends AbstractStaticCommand {
    private PropertyType[] propertyTypes_;

    public AbstractAutoStaticCommand(DataSource dataSource, StatementFactory statementFactory, BeanMetaData beanMetaData, String[] propertyNames) {
        super(dataSource, statementFactory, beanMetaData);
        this.setupPropertyTypes(propertyNames);
        this.setupSql();
    }

    public Object execute(Object[] args) {
        AbstractAutoHandler handler = this.createAutoHandler();
        handler.setSql(this.getSql());
        int rows = handler.execute(args);
        if (rows != 1) {
            throw new NotSingleRowUpdatedRuntimeException(args[0], rows);
        }
        return new Integer(rows);
    }

    protected PropertyType[] getPropertyTypes() {
        return this.propertyTypes_;
    }

    protected void setPropertyTypes(PropertyType[] propertyTypes) {
        this.propertyTypes_ = propertyTypes;
    }

    protected abstract AbstractAutoHandler createAutoHandler();

    protected abstract void setupPropertyTypes(String[] var1);

    protected void setupInsertPropertyTypes(String[] propertyNames) {
        ArrayList<PropertyType> types = new ArrayList<PropertyType>();
        int i = 0;
        while (i < propertyNames.length) {
            PropertyType pt = this.getBeanMetaData().getPropertyType(propertyNames[i]);
            if (!pt.isPrimaryKey() || this.getBeanMetaData().getIdentifierGenerator().isSelfGenerate()) {
                types.add(pt);
            }
            ++i;
        }
        this.propertyTypes_ = types.toArray(new PropertyType[types.size()]);
    }

    protected void setupUpdatePropertyTypes(String[] propertyNames) {
        ArrayList<PropertyType> types = new ArrayList<PropertyType>();
        int i = 0;
        while (i < propertyNames.length) {
            PropertyType pt = this.getBeanMetaData().getPropertyType(propertyNames[i]);
            if (!pt.isPrimaryKey()) {
                types.add(pt);
            }
            ++i;
        }
        this.propertyTypes_ = types.toArray(new PropertyType[types.size()]);
    }

    protected void setupDeletePropertyTypes(String[] propertyNames) {
    }

    protected abstract void setupSql();

    protected void setupInsertSql() {
        BeanMetaData bmd = this.getBeanMetaData();
        StringBuffer buf = new StringBuffer(100);
        buf.append("INSERT INTO ");
        buf.append(bmd.getTableName());
        buf.append(" (");
        int i = 0;
        while (i < this.propertyTypes_.length) {
            PropertyType pt = this.propertyTypes_[i];
            buf.append(pt.getColumnName());
            buf.append(", ");
            ++i;
        }
        buf.setLength(buf.length() - 2);
        buf.append(") VALUES (");
        i = 0;
        while (i < this.propertyTypes_.length) {
            buf.append("?, ");
            ++i;
        }
        buf.setLength(buf.length() - 2);
        buf.append(")");
        this.setSql(buf.toString());
    }

    protected void setupUpdateSql() {
        this.checkPrimaryKey();
        StringBuffer buf = new StringBuffer(100);
        buf.append("UPDATE ");
        buf.append(this.getBeanMetaData().getTableName());
        buf.append(" SET ");
        int i = 0;
        while (i < this.propertyTypes_.length) {
            PropertyType pt = this.propertyTypes_[i];
            buf.append(pt.getColumnName());
            buf.append(" = ?, ");
            ++i;
        }
        buf.setLength(buf.length() - 2);
        this.setupUpdateWhere(buf);
        this.setSql(buf.toString());
    }

    protected void setupDeleteSql() {
        this.checkPrimaryKey();
        StringBuffer buf = new StringBuffer(100);
        buf.append("DELETE FROM ");
        buf.append(this.getBeanMetaData().getTableName());
        this.setupUpdateWhere(buf);
        this.setSql(buf.toString());
    }

    protected void checkPrimaryKey() {
        BeanMetaData bmd = this.getBeanMetaData();
        if (bmd.getPrimaryKeySize() == 0) {
            throw new PrimaryKeyNotFoundRuntimeException(bmd.getBeanClass());
        }
    }

    protected void setupUpdateWhere(StringBuffer buf) {
        BeanMetaData bmd = this.getBeanMetaData();
        buf.append(" WHERE ");
        int i = 0;
        while (i < bmd.getPrimaryKeySize()) {
            buf.append(bmd.getPrimaryKey(i));
            buf.append(" = ? AND ");
            ++i;
        }
        buf.setLength(buf.length() - 5);
        if (bmd.hasVersionNoPropertyType()) {
            PropertyType pt = bmd.getVersionNoPropertyType();
            buf.append(" AND ");
            buf.append(pt.getColumnName());
            buf.append(" = ?");
        }
        if (bmd.hasTimestampPropertyType()) {
            PropertyType pt = bmd.getTimestampPropertyType();
            buf.append(" AND ");
            buf.append(pt.getColumnName());
            buf.append(" = ?");
        }
    }
}

