/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.jarjar;

import com.tonicsystems.jarjar.ClassPathIterator;
import com.tonicsystems.jarjar.DepFindException;
import com.tonicsystems.jarjar.DepFindVisitor;
import com.tonicsystems.jarjar.WrappedIOException;
import com.tonicsystems.jarjar.asm.ClassReader;
import com.tonicsystems.jarjar.cglib.ClassNameReader;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;

public class DepFind {
    public static void main(String[] args) throws Exception {
        try {
            new DepFind(args);
        }
        catch (WrappedIOException e) {
            throw (IOException)e.getCause();
        }
    }

    private DepFind(String[] args) throws Exception {
        Object source;
        Object cls;
        if (args.length != 2) {
            System.err.println("Syntax: java com.tonicsystems.jarjar.DepFind <find-classpath> <source-classpath>");
            System.exit(1);
        }
        File curDir = new File(System.getProperty("user.dir"));
        HashMap<String, Object> classes = new HashMap<String, Object>();
        ClassPathIterator cp = new ClassPathIterator(curDir, args[0]);
        while (cp.hasNext()) {
            cls = cp.next();
            source = cp.getSource(cls);
            String name = ClassNameReader.getClassName(new ClassReader(cp.getInputStream(cls)));
            classes.put(name.replace('.', '/'), source);
        }
        cp.close();
        cp = new ClassPathIterator(curDir, args[1]);
        while (cp.hasNext()) {
            try {
                cls = cp.next();
                source = cp.getSource(cls);
                new ClassReader(cp.getInputStream(cls)).accept(new DepFindVisitor(classes, source), true);
            }
            catch (DepFindException e) {
                System.out.println(e.getClassName() + " (" + e.getDependency() + ")");
            }
        }
        cp.close();
    }
}

