/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.sql.DataSource;
import org.seasar.dao.BeanMetaData;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.extension.jdbc.StatementFactory;
import org.seasar.extension.jdbc.UpdateHandler;
import org.seasar.extension.jdbc.impl.BasicHandler;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.exception.SQLRuntimeException;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.ConnectionUtil;
import org.seasar.framework.util.IntegerConversionUtil;
import org.seasar.framework.util.PreparedStatementUtil;
import org.seasar.framework.util.StatementUtil;

public abstract class AbstractAutoHandler
extends BasicHandler
implements UpdateHandler {
    private static Logger logger_;
    private BeanMetaData beanMetaData_;
    private Object[] bindVariables_;
    private Class[] bindVariableTypes_;
    private Timestamp timestamp_;
    private Integer versionNo_;
    private PropertyType[] propertyTypes_;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.seasar.dao.impl.AbstractAutoHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger_ = Logger.getLogger((Class)clazz);
    }

    public AbstractAutoHandler(DataSource dataSource, StatementFactory statementFactory, BeanMetaData beanMetaData, PropertyType[] propertyTypes) {
        this.setDataSource(dataSource);
        this.setStatementFactory(statementFactory);
        this.beanMetaData_ = beanMetaData;
        this.propertyTypes_ = propertyTypes;
    }

    public BeanMetaData getBeanMetaData() {
        return this.beanMetaData_;
    }

    protected static Logger getLogger() {
        return logger_;
    }

    protected Object[] getBindVariables() {
        return this.bindVariables_;
    }

    protected void setBindVariables(Object[] bindVariables) {
        this.bindVariables_ = bindVariables;
    }

    protected Class[] getBindVariableTypes() {
        return this.bindVariableTypes_;
    }

    protected void setBindVariableTypes(Class[] types) {
        this.bindVariableTypes_ = types;
    }

    protected Timestamp getTimestamp() {
        return this.timestamp_;
    }

    protected void setTimestamp(Timestamp timestamp) {
        this.timestamp_ = timestamp;
    }

    protected Integer getVersionNo() {
        return this.versionNo_;
    }

    protected void setVersionNo(Integer versionNo) {
        this.versionNo_ = versionNo;
    }

    protected PropertyType[] getPropertyTypes() {
        return this.propertyTypes_;
    }

    protected void setPropertyTypes(PropertyType[] propertyTypes) {
        this.propertyTypes_ = propertyTypes;
    }

    public int execute(Object[] args) throws SQLRuntimeException {
        int n;
        Connection connection = this.getConnection();
        try {
            n = this.execute(connection, args[0]);
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            ConnectionUtil.close((Connection)connection);
            throw throwable;
        }
        ConnectionUtil.close((Connection)connection);
        return n;
    }

    public int execute(Object[] args, Class[] argTypes) throws SQLRuntimeException {
        return this.execute(args);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int execute(Connection connection, Object bean) {
        this.preUpdateBean(bean);
        this.setupBindVariables(bean);
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)this.getCompleteSql(this.bindVariables_));
        }
        PreparedStatement ps = this.prepareStatement(connection);
        int ret = -1;
        try {
            this.bindArgs(ps, this.bindVariables_, this.bindVariableTypes_);
            ret = PreparedStatementUtil.executeUpdate((PreparedStatement)ps);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            StatementUtil.close((Statement)ps);
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        StatementUtil.close((Statement)ps);
        this.postUpdateBean(bean);
        return ret;
    }

    protected void preUpdateBean(Object bean) {
    }

    protected void postUpdateBean(Object bean) {
    }

    protected abstract void setupBindVariables(Object var1);

    protected void setupInsertBindVariables(Object bean) {
        ArrayList<Object> varList = new ArrayList<Object>();
        ArrayList<Class> varTypeList = new ArrayList<Class>();
        int i = 0;
        while (i < this.propertyTypes_.length) {
            PropertyType pt = this.propertyTypes_[i];
            if (pt.getPropertyName().equalsIgnoreCase(this.getBeanMetaData().getTimestampPropertyName())) {
                this.setTimestamp(new Timestamp(new Date().getTime()));
                varList.add(this.getTimestamp());
            } else if (pt.getPropertyName().equals(this.getBeanMetaData().getVersionNoPropertyName())) {
                this.setVersionNo(new Integer(0));
                varList.add(this.getVersionNo());
            } else {
                varList.add(pt.getPropertyDesc().getValue(bean));
            }
            varTypeList.add(pt.getPropertyDesc().getPropertyType());
            ++i;
        }
        this.setBindVariables(varList.toArray());
        this.setBindVariableTypes(varTypeList.toArray(new Class[varTypeList.size()]));
    }

    protected void setupUpdateBindVariables(Object bean) {
        ArrayList<Object> varList = new ArrayList<Object>();
        ArrayList<Class> varTypeList = new ArrayList<Class>();
        int i = 0;
        while (i < this.propertyTypes_.length) {
            PropertyType pt = this.propertyTypes_[i];
            if (pt.getPropertyName().equalsIgnoreCase(this.getBeanMetaData().getTimestampPropertyName())) {
                this.setTimestamp(new Timestamp(new Date().getTime()));
                varList.add(this.getTimestamp());
            } else if (pt.getPropertyName().equals(this.getBeanMetaData().getVersionNoPropertyName())) {
                Object value = pt.getPropertyDesc().getValue(bean);
                int intValue = IntegerConversionUtil.toPrimitiveInt((Object)value) + 1;
                this.setVersionNo(new Integer(intValue));
                varList.add(this.getVersionNo());
            } else {
                varList.add(pt.getPropertyDesc().getValue(bean));
            }
            varTypeList.add(pt.getPropertyDesc().getPropertyType());
            ++i;
        }
        this.addAutoUpdateWhereBindVariables(varList, varTypeList, bean);
        this.setBindVariables(varList.toArray());
        this.setBindVariableTypes(varTypeList.toArray(new Class[varTypeList.size()]));
    }

    protected void setupDeleteBindVariables(Object bean) {
        ArrayList varList = new ArrayList();
        ArrayList varTypeList = new ArrayList();
        this.addAutoUpdateWhereBindVariables(varList, varTypeList, bean);
        this.setBindVariables(varList.toArray());
        this.setBindVariableTypes(varTypeList.toArray(new Class[varTypeList.size()]));
    }

    protected void addAutoUpdateWhereBindVariables(List varList, List varTypeList, Object bean) {
        PropertyDesc pd;
        BeanMetaData bmd = this.getBeanMetaData();
        int i = 0;
        while (i < bmd.getPrimaryKeySize()) {
            PropertyType pt = bmd.getPropertyTypeByColumnName(bmd.getPrimaryKey(i));
            PropertyDesc pd2 = pt.getPropertyDesc();
            varList.add(pd2.getValue(bean));
            varTypeList.add(pd2.getPropertyType());
            ++i;
        }
        if (bmd.hasVersionNoPropertyType()) {
            PropertyType pt = bmd.getVersionNoPropertyType();
            pd = pt.getPropertyDesc();
            varList.add(pd.getValue(bean));
            varTypeList.add(pd.getPropertyType());
        }
        if (bmd.hasTimestampPropertyType()) {
            PropertyType pt = bmd.getTimestampPropertyType();
            pd = pt.getPropertyDesc();
            varList.add(pd.getValue(bean));
            varTypeList.add(pd.getPropertyType());
        }
    }

    protected void updateTimestampIfNeed(Object bean) {
        if (this.getTimestamp() != null) {
            PropertyDesc pd = this.getBeanMetaData().getTimestampPropertyType().getPropertyDesc();
            pd.setValue(bean, (Object)this.getTimestamp());
        }
    }

    protected void updateVersionNoIfNeed(Object bean) {
        if (this.getVersionNo() != null) {
            PropertyDesc pd = this.getBeanMetaData().getVersionNoPropertyType().getPropertyDesc();
            pd.setValue(bean, (Object)this.getVersionNo());
        }
    }
}

