/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.tx;

import java.util.ArrayList;
import java.util.List;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.aopalliance.intercept.MethodInterceptor;
import org.seasar.framework.exception.SIllegalArgumentException;

public abstract class AbstractTxInterceptor
implements MethodInterceptor {
    private TransactionManager transactionManager_;
    private List txRules_ = new ArrayList();

    public AbstractTxInterceptor(TransactionManager transactionManager) {
        this.transactionManager_ = transactionManager;
    }

    public final TransactionManager getTransactionManager() {
        return this.transactionManager_;
    }

    public final boolean hasTransaction() throws SystemException {
        return this.transactionManager_.getStatus() != 6;
    }

    public final Transaction getTransaction() throws SystemException {
        return this.transactionManager_.getTransaction();
    }

    public final void begin() throws NotSupportedException, SystemException {
        this.transactionManager_.begin();
    }

    public final void commit() throws SecurityException, IllegalStateException, RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException {
        this.transactionManager_.commit();
    }

    public final void rollback() throws IllegalStateException, SecurityException, SystemException {
        if (this.hasTransaction()) {
            this.transactionManager_.rollback();
        }
    }

    public final Transaction suspend() throws SystemException {
        return this.transactionManager_.suspend();
    }

    public final void resume(Transaction transaction) throws InvalidTransactionException, IllegalStateException, SystemException {
        this.transactionManager_.resume(transaction);
    }

    public final boolean complete(Throwable t) throws SecurityException, IllegalStateException, RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException {
        int i = 0;
        while (i < this.txRules_.size()) {
            TxRule rule = (TxRule)this.txRules_.get(i);
            if (rule.isAssignableFrom(t)) {
                return rule.complete();
            }
            ++i;
        }
        this.rollback();
        return false;
    }

    public final void addCommitRule(Class exceptionClass) {
        this.txRules_.add(new TxRule(exceptionClass, true));
    }

    public final void addRollbackRule(Class exceptionClass) {
        this.txRules_.add(new TxRule(exceptionClass, false));
    }

    private class TxRule {
        private Class exceptionClass_;
        private boolean commit_;
        static /* synthetic */ Class class$0;

        public TxRule(Class exceptionClass, boolean commit) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Throwable");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!clazz.isAssignableFrom(exceptionClass)) {
                throw new SIllegalArgumentException("ESSR0365", new Object[]{exceptionClass.getName()});
            }
            this.exceptionClass_ = exceptionClass;
            this.commit_ = commit;
        }

        public boolean isAssignableFrom(Throwable t) {
            return this.exceptionClass_.isAssignableFrom(t.getClass());
        }

        public boolean complete() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException {
            if (this.commit_) {
                AbstractTxInterceptor.this.commit();
            } else {
                AbstractTxInterceptor.this.rollback();
            }
            return this.commit_;
        }
    }
}

