/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.model;

import java.util.SortedMap;
import javax.faces.model.DataModel;
import javax.faces.model.DataModelEvent;
import javax.faces.model.DataModelListener;
import javax.servlet.jsp.jstl.sql.Result;

public class ResultDataModel
extends DataModel {
    private int _rowIndex = -1;
    private SortedMap[] _data;

    public ResultDataModel() {
    }

    public ResultDataModel(Result result) {
        if (result == null) {
            throw new NullPointerException("result");
        }
        this.setWrappedData(result);
    }

    public int getRowCount() {
        if (this._data == null) {
            return -1;
        }
        return this._data.length;
    }

    public Object getRowData() {
        if (this._data == null) {
            return null;
        }
        if (!this.isRowAvailable()) {
            throw new IllegalArgumentException("row is unavailable");
        }
        return this._data[this._rowIndex];
    }

    public int getRowIndex() {
        return this._rowIndex;
    }

    public Object getWrappedData() {
        return this._data;
    }

    public boolean isRowAvailable() {
        if (this._data == null) {
            return false;
        }
        return this._rowIndex >= 0 && this._rowIndex < this._data.length;
    }

    public void setRowIndex(int rowIndex) {
        if (rowIndex < -1) {
            throw new IllegalArgumentException("illegal rowIndex " + rowIndex);
        }
        int oldRowIndex = this._rowIndex;
        this._rowIndex = rowIndex;
        if (this._data != null && oldRowIndex != this._rowIndex) {
            Object data = this.isRowAvailable() ? this.getRowData() : null;
            DataModelEvent event = new DataModelEvent(this, this._rowIndex, data);
            DataModelListener[] listeners = this.getDataModelListeners();
            int i = 0;
            while (i < listeners.length) {
                listeners[i].rowSelected(event);
                ++i;
            }
        }
    }

    public void setWrappedData(Object data) {
        if (data == null) {
            this.setRowIndex(-1);
        } else {
            this._data = ((Result)data).getRows();
            this.setRowIndex(0);
        }
    }
}

