/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.NavigationHandler;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.context.ExternalContext;
import javax.faces.el.PropertyResolver;
import javax.faces.el.VariableResolver;
import javax.faces.event.ActionListener;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.application.ApplicationImpl;
import org.apache.myfaces.config.FacesConfigDispenser;
import org.apache.myfaces.config.FacesConfigUnmarshaller;
import org.apache.myfaces.config.RuntimeConfig;
import org.apache.myfaces.config.element.ManagedBean;
import org.apache.myfaces.config.element.NavigationRule;
import org.apache.myfaces.config.element.Renderer;
import org.apache.myfaces.config.impl.digester.DigesterFacesConfigDispenserImpl;
import org.apache.myfaces.config.impl.digester.DigesterFacesConfigUnmarshallerImpl;
import org.apache.myfaces.util.ClassUtils;
import org.apache.myfaces.util.LocaleUtils;
import org.xml.sax.SAXException;

public class FacesConfigurator {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$config$FacesConfigurator == null ? (class$org$apache$myfaces$config$FacesConfigurator = FacesConfigurator.class$("org.apache.myfaces.config.FacesConfigurator")) : class$org$apache$myfaces$config$FacesConfigurator));
    private static final String STANDARD_FACES_CONFIG_RESOURCE = "org.apache.myfaces.resource".replace('.', '/') + "/standard-faces-config.xml";
    public static final String APPLICATION_MAP_LIFECYCLE_KEY = (class$javax$faces$lifecycle$Lifecycle == null ? (class$javax$faces$lifecycle$Lifecycle = FacesConfigurator.class$("javax.faces.lifecycle.Lifecycle")) : class$javax$faces$lifecycle$Lifecycle).getName();
    public static final String META_INF_SERVICES_LOCATION = "/META-INF/services/";
    private static final String DEFAULT_RENDER_KIT_CLASS = (class$org$apache$myfaces$renderkit$html$HtmlRenderKitImpl == null ? (class$org$apache$myfaces$renderkit$html$HtmlRenderKitImpl = FacesConfigurator.class$("org.apache.myfaces.renderkit.html.HtmlRenderKitImpl")) : class$org$apache$myfaces$renderkit$html$HtmlRenderKitImpl).getName();
    private static final String DEFAULT_APPLICATION_FACTORY = (class$org$apache$myfaces$application$ApplicationFactoryImpl == null ? (class$org$apache$myfaces$application$ApplicationFactoryImpl = FacesConfigurator.class$("org.apache.myfaces.application.ApplicationFactoryImpl")) : class$org$apache$myfaces$application$ApplicationFactoryImpl).getName();
    private static final String DEFAULT_FACES_CONTEXT_FACTORY = (class$org$apache$myfaces$context$FacesContextFactoryImpl == null ? (class$org$apache$myfaces$context$FacesContextFactoryImpl = FacesConfigurator.class$("org.apache.myfaces.context.FacesContextFactoryImpl")) : class$org$apache$myfaces$context$FacesContextFactoryImpl).getName();
    private static final String DEFAULT_LIFECYCLE_FACTORY = (class$org$apache$myfaces$lifecycle$LifecycleFactoryImpl == null ? (class$org$apache$myfaces$lifecycle$LifecycleFactoryImpl = FacesConfigurator.class$("org.apache.myfaces.lifecycle.LifecycleFactoryImpl")) : class$org$apache$myfaces$lifecycle$LifecycleFactoryImpl).getName();
    private static final String DEFAULT_RENDER_KIT_FACTORY = (class$org$apache$myfaces$renderkit$RenderKitFactoryImpl == null ? (class$org$apache$myfaces$renderkit$RenderKitFactoryImpl = FacesConfigurator.class$("org.apache.myfaces.renderkit.RenderKitFactoryImpl")) : class$org$apache$myfaces$renderkit$RenderKitFactoryImpl).getName();
    private static final Set FACTORY_NAMES = new HashSet();
    private ExternalContext _externalContext;
    private FacesConfigUnmarshaller _unmarshaller;
    private FacesConfigDispenser _dispenser;
    static /* synthetic */ Class class$org$apache$myfaces$config$FacesConfigurator;
    static /* synthetic */ Class class$javax$faces$lifecycle$Lifecycle;
    static /* synthetic */ Class class$org$apache$myfaces$renderkit$html$HtmlRenderKitImpl;
    static /* synthetic */ Class class$org$apache$myfaces$application$ApplicationFactoryImpl;
    static /* synthetic */ Class class$org$apache$myfaces$context$FacesContextFactoryImpl;
    static /* synthetic */ Class class$org$apache$myfaces$lifecycle$LifecycleFactoryImpl;
    static /* synthetic */ Class class$org$apache$myfaces$renderkit$RenderKitFactoryImpl;
    static /* synthetic */ Class class$javax$faces$event$ActionListener;
    static /* synthetic */ Class class$javax$faces$application$NavigationHandler;
    static /* synthetic */ Class class$javax$faces$el$PropertyResolver;
    static /* synthetic */ Class class$javax$faces$application$StateManager;
    static /* synthetic */ Class class$javax$faces$el$VariableResolver;
    static /* synthetic */ Class class$javax$faces$application$ViewHandler;

    public FacesConfigurator(ExternalContext externalContext) {
        FACTORY_NAMES.add("javax.faces.application.ApplicationFactory");
        FACTORY_NAMES.add("javax.faces.context.FacesContextFactory");
        FACTORY_NAMES.add("javax.faces.lifecycle.LifecycleFactory");
        FACTORY_NAMES.add("javax.faces.render.RenderKitFactory");
        this._externalContext = externalContext;
    }

    public void configure() throws FacesException {
        this._unmarshaller = new DigesterFacesConfigUnmarshallerImpl(this._externalContext);
        this._dispenser = new DigesterFacesConfigDispenserImpl();
        try {
            this.feedStandardConfig();
            this.feedMetaInfServicesFactories();
            this.feedJarFileConfigurations();
            this.feedContextSpecifiedConfig();
            this.feedWebAppConfig();
        }
        catch (IOException e) {
            throw new FacesException(e);
        }
        catch (SAXException e) {
            throw new FacesException(e);
        }
        this.configureFactories();
        this.configureApplication();
        this.configureRenderKits();
        this.configureRuntimeConfig();
        this.configureLifecycle();
    }

    private void feedStandardConfig() throws IOException, SAXException {
        InputStream stream = ClassUtils.getResourceAsStream(STANDARD_FACES_CONFIG_RESOURCE);
        if (stream == null) {
            throw new FacesException("Standard faces config " + STANDARD_FACES_CONFIG_RESOURCE + " not found");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Reading standard config " + STANDARD_FACES_CONFIG_RESOURCE));
        }
        this._dispenser.feed(this._unmarshaller.getFacesConfig(stream, STANDARD_FACES_CONFIG_RESOURCE));
    }

    protected void feedMetaInfServicesFactories() {
        Map resourceNames = this.expandFactoryNames(FACTORY_NAMES);
        Set services = this._externalContext.getResourcePaths(META_INF_SERVICES_LOCATION);
        if (null != services) {
            services.retainAll(resourceNames.keySet());
            Iterator itr = services.iterator();
            while (itr.hasNext()) {
                String resourceName = (String)itr.next();
                InputStream is = this._externalContext.getResourceAsStream(resourceName);
                InputStreamReader isr = new InputStreamReader(is);
                BufferedReader br = new BufferedReader(isr);
                String className = null;
                try {
                    className = br.readLine();
                }
                catch (IOException e) {
                    throw new FacesException("Unable to read class name from file " + resourceName, e);
                }
                String factoryName = (String)resourceNames.get(resourceName);
                if (factoryName.equals("javax.faces.application.ApplicationFactory")) {
                    this._dispenser.feedApplicationFactory(className);
                    continue;
                }
                if (factoryName.equals("javax.faces.context.FacesContextFactory")) {
                    this._dispenser.feedFacesContextFactory(className);
                    continue;
                }
                if (factoryName.equals("javax.faces.lifecycle.LifecycleFactory")) {
                    this._dispenser.feedLifecycleFactory(className);
                    continue;
                }
                if (factoryName.equals("javax.faces.render.RenderKitFactory")) {
                    this._dispenser.feedRenderKitFactory(className);
                    continue;
                }
                throw new IllegalStateException("Unexpected factory name " + factoryName);
            }
        }
    }

    private Map expandFactoryNames(Set factoryNames) {
        HashMap<String, String> names = new HashMap<String, String>();
        Iterator itr = factoryNames.iterator();
        while (itr.hasNext()) {
            String name = (String)itr.next();
            names.put(META_INF_SERVICES_LOCATION + name, name);
        }
        return names;
    }

    private void feedJarFileConfigurations() {
        Set jars = this._externalContext.getResourcePaths("/WEB-INF/lib/");
        if (jars != null) {
            Iterator it = jars.iterator();
            while (it.hasNext()) {
                String path = (String)it.next();
                if (!path.toLowerCase().endsWith(".jar")) continue;
                this.feedJarConfig(path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void feedJarConfig(String jarPath) throws FacesException {
        block15: {
            try {
                InputStream in = this._externalContext.getResourceAsStream(jarPath);
                if (in == null) {
                    in = jarPath.startsWith("/") ? this._externalContext.getResourceAsStream(jarPath.substring(1)) : this._externalContext.getResourceAsStream("/" + jarPath);
                }
                if (in == null) {
                    log.error((Object)("Resource " + jarPath + " not found"));
                    return;
                }
                JarInputStream jar = new JarInputStream(in);
                JarEntry entry = jar.getNextJarEntry();
                boolean found = false;
                while (entry != null) {
                    if (entry.getName().equals("META-INF/faces-config.xml")) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("faces-config.xml found in " + jarPath));
                        }
                        found = true;
                        break;
                    }
                    entry = jar.getNextJarEntry();
                }
                jar.close();
                File tmp = null;
                if (found) {
                    int r;
                    tmp = File.createTempFile("myfaces", ".jar");
                    in = this._externalContext.getResourceAsStream(jarPath);
                    FileOutputStream out = new FileOutputStream(tmp);
                    byte[] buffer = new byte[4096];
                    while ((r = in.read(buffer)) != -1) {
                        void var9_10;
                        out.write(buffer, 0, (int)var9_10);
                    }
                    out.close();
                    JarFile jarFile = new JarFile(tmp);
                    try {
                        JarEntry configFile = jarFile.getJarEntry("META-INF/faces-config.xml");
                        if (configFile != null) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("faces-config.xml found in jar " + jarPath));
                            }
                            InputStream stream = jarFile.getInputStream(configFile);
                            String systemId = "jar:" + tmp.toURL() + "!/" + configFile.getName();
                            if (log.isInfoEnabled()) {
                                log.info((Object)("Reading config " + systemId));
                            }
                            this._dispenser.feed(this._unmarshaller.getFacesConfig(stream, systemId));
                        }
                        Object var15_15 = null;
                    }
                    catch (Throwable throwable) {
                        Object var15_16 = null;
                        jarFile.close();
                        tmp.delete();
                        throw throwable;
                    }
                    jarFile.close();
                    tmp.delete();
                    {
                        break block15;
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Jar " + jarPath + " contains no faces-config.xml"));
                }
            }
            catch (Exception e) {
                throw new FacesException(e);
            }
        }
    }

    private void feedContextSpecifiedConfig() throws IOException, SAXException {
        String configFiles = this._externalContext.getInitParameter("javax.faces.CONFIG_FILES");
        if (configFiles != null) {
            StringTokenizer st = new StringTokenizer(configFiles, ",", false);
            while (st.hasMoreTokens()) {
                String systemId = st.nextToken().trim();
                InputStream stream = this._externalContext.getResourceAsStream(systemId);
                if (stream == null) {
                    log.error((Object)("Faces config resource " + systemId + " not found"));
                    continue;
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("Reading config " + systemId));
                }
                this._dispenser.feed(this._unmarshaller.getFacesConfig(stream, systemId));
            }
        }
    }

    private void feedWebAppConfig() throws IOException, SAXException {
        String systemId = "/WEB-INF/faces-config.xml";
        InputStream stream = this._externalContext.getResourceAsStream(systemId);
        if (stream != null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Reading config /WEB-INF/faces-config.xml");
            }
            this._dispenser.feed(this._unmarshaller.getFacesConfig(stream, systemId));
        }
    }

    private void configureFactories() {
        this.setFactories("javax.faces.application.ApplicationFactory", this._dispenser.getApplicationFactoryIterator(), DEFAULT_APPLICATION_FACTORY);
        this.setFactories("javax.faces.context.FacesContextFactory", this._dispenser.getFacesContextFactoryIterator(), DEFAULT_FACES_CONTEXT_FACTORY);
        this.setFactories("javax.faces.lifecycle.LifecycleFactory", this._dispenser.getLifecycleFactoryIterator(), DEFAULT_LIFECYCLE_FACTORY);
        this.setFactories("javax.faces.render.RenderKitFactory", this._dispenser.getRenderKitFactoryIterator(), DEFAULT_RENDER_KIT_FACTORY);
    }

    private void setFactories(String factoryName, Iterator factories, String defaultFactory) {
        FactoryFinder.setFactory(factoryName, defaultFactory);
        while (factories.hasNext()) {
            FactoryFinder.setFactory(factoryName, (String)factories.next());
        }
    }

    private void configureApplication() {
        Iterator it;
        Application application = ((ApplicationFactory)FactoryFinder.getFactory("javax.faces.application.ApplicationFactory")).getApplication();
        application.setActionListener((ActionListener)this.getApplicationObject(class$javax$faces$event$ActionListener == null ? (class$javax$faces$event$ActionListener = FacesConfigurator.class$("javax.faces.event.ActionListener")) : class$javax$faces$event$ActionListener, this._dispenser.getActionListenerIterator(), null));
        if (this._dispenser.getDefaultLocale() != null) {
            application.setDefaultLocale(LocaleUtils.toLocale(this._dispenser.getDefaultLocale()));
        }
        if (this._dispenser.getDefaultRenderKitId() != null) {
            application.setDefaultRenderKitId(this._dispenser.getDefaultRenderKitId());
        }
        if (this._dispenser.getMessageBundle() != null) {
            application.setMessageBundle(this._dispenser.getMessageBundle());
        }
        application.setNavigationHandler((NavigationHandler)this.getApplicationObject(class$javax$faces$application$NavigationHandler == null ? (class$javax$faces$application$NavigationHandler = FacesConfigurator.class$("javax.faces.application.NavigationHandler")) : class$javax$faces$application$NavigationHandler, this._dispenser.getNavigationHandlerIterator(), application.getNavigationHandler()));
        application.setPropertyResolver((PropertyResolver)this.getApplicationObject(class$javax$faces$el$PropertyResolver == null ? (class$javax$faces$el$PropertyResolver = FacesConfigurator.class$("javax.faces.el.PropertyResolver")) : class$javax$faces$el$PropertyResolver, this._dispenser.getPropertyResolverIterator(), application.getPropertyResolver()));
        application.setStateManager((StateManager)this.getApplicationObject(class$javax$faces$application$StateManager == null ? (class$javax$faces$application$StateManager = FacesConfigurator.class$("javax.faces.application.StateManager")) : class$javax$faces$application$StateManager, this._dispenser.getStateManagerIterator(), application.getStateManager()));
        ArrayList<Locale> locales = new ArrayList<Locale>();
        Iterator it2 = this._dispenser.getSupportedLocalesIterator();
        while (it2.hasNext()) {
            locales.add(LocaleUtils.toLocale((String)it2.next()));
        }
        application.setSupportedLocales(locales);
        application.setVariableResolver((VariableResolver)this.getApplicationObject(class$javax$faces$el$VariableResolver == null ? (class$javax$faces$el$VariableResolver = FacesConfigurator.class$("javax.faces.el.VariableResolver")) : class$javax$faces$el$VariableResolver, this._dispenser.getVariableResolverIterator(), application.getVariableResolver()));
        application.setViewHandler((ViewHandler)this.getApplicationObject(class$javax$faces$application$ViewHandler == null ? (class$javax$faces$application$ViewHandler = FacesConfigurator.class$("javax.faces.application.ViewHandler")) : class$javax$faces$application$ViewHandler, this._dispenser.getViewHandlerIterator(), application.getViewHandler()));
        Iterator it3 = this._dispenser.getComponentTypes();
        while (it3.hasNext()) {
            String componentType = (String)it3.next();
            application.addComponent(componentType, this._dispenser.getComponentClass(componentType));
        }
        Iterator it4 = this._dispenser.getConverterIds();
        while (it4.hasNext()) {
            String converterId = (String)it4.next();
            application.addConverter(converterId, this._dispenser.getConverterClassById(converterId));
        }
        Iterator it5 = this._dispenser.getConverterClasses();
        while (it5.hasNext()) {
            String converterClass = (String)it5.next();
            try {
                application.addConverter(ClassUtils.simpleClassForName(converterClass), this._dispenser.getConverterClassByClass(converterClass));
            }
            catch (Exception ex) {
                log.error((Object)"Converter could not be added. Reason:", (Throwable)ex);
            }
        }
        if (application instanceof ApplicationImpl) {
            it = this._dispenser.getConverterConfigurationByClassName();
            while (it.hasNext()) {
                String converterClassName = (String)it.next();
                ((ApplicationImpl)application).addConverterConfiguration(converterClassName, this._dispenser.getConverterConfiguration(converterClassName));
            }
        }
        it = this._dispenser.getValidatorIds();
        while (it.hasNext()) {
            String validatorId = (String)it.next();
            application.addValidator(validatorId, this._dispenser.getValidatorClass(validatorId));
        }
    }

    private Object getApplicationObject(Class interfaceClass, Iterator classNamesIterator, Object defaultObject) {
        Object current = defaultObject;
        while (classNamesIterator.hasNext()) {
            String implClassName = (String)classNamesIterator.next();
            Class implClass = ClassUtils.simpleClassForName(implClassName);
            if (!interfaceClass.isAssignableFrom(implClass)) {
                throw new IllegalArgumentException("Class " + implClassName + " is no " + interfaceClass.getName());
            }
            if (current == null) {
                current = ClassUtils.newInstance(implClass);
                continue;
            }
            try {
                Constructor delegationConstructor = implClass.getConstructor(interfaceClass);
                try {
                    current = delegationConstructor.newInstance(current);
                }
                catch (InstantiationException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    throw new FacesException(e);
                }
                catch (IllegalAccessException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    throw new FacesException(e);
                }
                catch (InvocationTargetException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    throw new FacesException(e);
                }
            }
            catch (NoSuchMethodException e) {
                current = ClassUtils.newInstance(implClass);
            }
        }
        return current;
    }

    private void configureRuntimeConfig() {
        RuntimeConfig runtimeConfig = RuntimeConfig.getCurrentInstance(this._externalContext);
        Iterator iterator = this._dispenser.getManagedBeans();
        while (iterator.hasNext()) {
            ManagedBean bean = (ManagedBean)iterator.next();
            runtimeConfig.addManagedBean(bean.getManagedBeanName(), bean);
        }
        Iterator iterator2 = this._dispenser.getNavigationRules();
        while (iterator2.hasNext()) {
            NavigationRule rule = (NavigationRule)iterator2.next();
            runtimeConfig.addNavigationRule(rule);
        }
    }

    private void configureRenderKits() {
        RenderKitFactory renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory("javax.faces.render.RenderKitFactory");
        Iterator iterator = this._dispenser.getRenderKitIds();
        while (iterator.hasNext()) {
            String renderKitId = (String)iterator.next();
            String renderKitClass = this._dispenser.getRenderKitClass(renderKitId);
            if (renderKitClass == null) {
                renderKitClass = DEFAULT_RENDER_KIT_CLASS;
            }
            RenderKit renderKit = (RenderKit)ClassUtils.newInstance(renderKitClass);
            Iterator renderers = this._dispenser.getRenderers(renderKitId);
            while (renderers.hasNext()) {
                Renderer element = (Renderer)renderers.next();
                javax.faces.render.Renderer renderer = null;
                try {
                    renderer = (javax.faces.render.Renderer)ClassUtils.newInstance(element.getRendererClass());
                }
                catch (FacesException e) {
                    log.error((Object)("failed to configure class " + element.getRendererClass()), (Throwable)e);
                    continue;
                }
                renderKit.addRenderer(element.getComponentFamily(), element.getRendererType(), renderer);
            }
            renderKitFactory.addRenderKit(renderKitId, renderKit);
        }
    }

    private void configureLifecycle() {
        LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory("javax.faces.lifecycle.LifecycleFactory");
        Lifecycle lifecycle = lifecycleFactory.getLifecycle(this.getLifecycleId());
        Iterator iterator = this._dispenser.getLifecyclePhaseListeners();
        while (iterator.hasNext()) {
            String listenerClassName = (String)iterator.next();
            try {
                lifecycle.addPhaseListener((PhaseListener)ClassUtils.newInstance(listenerClassName));
            }
            catch (ClassCastException e) {
                log.error((Object)("Class " + listenerClassName + " does not implement PhaseListener"));
            }
        }
    }

    private String getLifecycleId() {
        String id = this._externalContext.getInitParameter("javax.faces.LIFECYCLE_ID");
        if (id != null) {
            return id;
        }
        return "DEFAULT";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

