/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.layout;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.custom.layout.HtmlPanelLayout;
import org.apache.myfaces.renderkit.RendererUtils;
import org.apache.myfaces.renderkit.html.HTML;
import org.apache.myfaces.renderkit.html.HtmlRenderer;
import org.apache.myfaces.renderkit.html.HtmlRendererUtils;

public class HtmlLayoutRenderer
extends HtmlRenderer {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$custom$layout$HtmlLayoutRenderer == null ? (class$org$apache$myfaces$custom$layout$HtmlLayoutRenderer = HtmlLayoutRenderer.class$("org.apache.myfaces.custom.layout.HtmlLayoutRenderer")) : class$org$apache$myfaces$custom$layout$HtmlLayoutRenderer));
    public static final String CLASSIC_LAYOUT = "classic";
    public static final String NAV_RIGHT_LAYOUT = "navigationRight";
    public static final String UPSIDE_DOWN_LAYOUT = "upsideDown";
    static /* synthetic */ Class class$org$apache$myfaces$custom$layout$HtmlLayoutRenderer;
    static /* synthetic */ Class class$org$apache$myfaces$custom$layout$HtmlPanelLayout;

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        RendererUtils.checkParamValidity(facesContext, component, class$org$apache$myfaces$custom$layout$HtmlPanelLayout == null ? (class$org$apache$myfaces$custom$layout$HtmlPanelLayout = HtmlLayoutRenderer.class$("org.apache.myfaces.custom.layout.HtmlPanelLayout")) : class$org$apache$myfaces$custom$layout$HtmlPanelLayout);
        HtmlPanelLayout panelLayout = (HtmlPanelLayout)component;
        String layout = panelLayout.getLayout();
        if (layout == null || layout.equals(CLASSIC_LAYOUT)) {
            this.renderClassic(facesContext, panelLayout);
        } else if (layout.equals(NAV_RIGHT_LAYOUT)) {
            this.renderNavRight(facesContext, panelLayout);
        } else if (layout.equals(UPSIDE_DOWN_LAYOUT)) {
            this.renderUpsideDown(facesContext, panelLayout);
        } else {
            log.error((Object)("Unknown panel layout '" + layout + "'!"));
        }
        if (panelLayout.getChildCount() > 0) {
            log.error((Object)"PanelLayout must not have children, only facets allowed!");
        }
    }

    protected void renderClassic(FacesContext facesContext, HtmlPanelLayout panelLayout) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        UIComponent header = panelLayout.getHeader();
        UIComponent navigation = panelLayout.getNavigation();
        UIComponent body = panelLayout.getBody();
        UIComponent footer = panelLayout.getFooter();
        writer.startElement("table", null);
        HtmlRendererUtils.renderHTMLAttributes(writer, panelLayout, HTML.TABLE_PASSTHROUGH_ATTRIBUTES);
        if (header != null) {
            writer.startElement("tr", null);
            this.renderTableCell(facesContext, writer, header, navigation != null && body != null ? 2 : 1, panelLayout.getHeaderClass(), panelLayout.getHeaderStyle());
            writer.endElement("tr");
        }
        if (navigation != null || body != null) {
            writer.startElement("tr", null);
            if (navigation != null) {
                this.renderTableCell(facesContext, writer, navigation, 0, panelLayout.getNavigationClass(), panelLayout.getNavigationStyle());
            }
            if (body != null) {
                this.renderTableCell(facesContext, writer, body, 0, panelLayout.getBodyClass(), panelLayout.getBodyStyle());
            }
            writer.endElement("tr");
        }
        if (footer != null) {
            writer.startElement("tr", null);
            this.renderTableCell(facesContext, writer, footer, navigation != null && body != null ? 2 : 1, panelLayout.getFooterClass(), panelLayout.getFooterStyle());
            writer.endElement("tr");
        }
        writer.endElement("table");
    }

    protected void renderNavRight(FacesContext facesContext, HtmlPanelLayout panelLayout) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        UIComponent header = panelLayout.getHeader();
        UIComponent navigation = panelLayout.getNavigation();
        UIComponent body = panelLayout.getBody();
        UIComponent footer = panelLayout.getFooter();
        writer.startElement("table", null);
        HtmlRendererUtils.renderHTMLAttributes(writer, panelLayout, HTML.TABLE_PASSTHROUGH_ATTRIBUTES);
        if (header != null) {
            writer.startElement("tr", null);
            this.renderTableCell(facesContext, writer, header, navigation != null && body != null ? 2 : 1, panelLayout.getHeaderClass(), panelLayout.getHeaderStyle());
            writer.endElement("tr");
        }
        if (navigation != null || body != null) {
            writer.startElement("tr", null);
            if (body != null) {
                this.renderTableCell(facesContext, writer, body, 0, panelLayout.getBodyClass(), panelLayout.getBodyStyle());
            }
            if (navigation != null) {
                this.renderTableCell(facesContext, writer, navigation, 0, panelLayout.getNavigationClass(), panelLayout.getNavigationStyle());
            }
            writer.endElement("tr");
        }
        if (footer != null) {
            writer.startElement("tr", null);
            this.renderTableCell(facesContext, writer, footer, navigation != null && body != null ? 2 : 1, panelLayout.getFooterClass(), panelLayout.getFooterStyle());
            writer.endElement("tr");
        }
        writer.endElement("table");
    }

    protected void renderUpsideDown(FacesContext facesContext, HtmlPanelLayout panelLayout) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        UIComponent header = panelLayout.getHeader();
        UIComponent navigation = panelLayout.getNavigation();
        UIComponent body = panelLayout.getBody();
        UIComponent footer = panelLayout.getFooter();
        writer.startElement("table", null);
        HtmlRendererUtils.renderHTMLAttributes(writer, panelLayout, HTML.TABLE_PASSTHROUGH_ATTRIBUTES);
        if (footer != null) {
            writer.startElement("tr", null);
            this.renderTableCell(facesContext, writer, footer, navigation != null && body != null ? 2 : 1, panelLayout.getFooterClass(), panelLayout.getFooterStyle());
            writer.endElement("tr");
        }
        if (navigation != null || body != null) {
            writer.startElement("tr", null);
            if (navigation != null) {
                this.renderTableCell(facesContext, writer, navigation, 0, panelLayout.getNavigationClass(), panelLayout.getNavigationStyle());
            }
            if (body != null) {
                this.renderTableCell(facesContext, writer, body, 0, panelLayout.getBodyClass(), panelLayout.getBodyStyle());
            }
            writer.endElement("tr");
        }
        if (header != null) {
            writer.startElement("tr", null);
            this.renderTableCell(facesContext, writer, header, navigation != null && body != null ? 2 : 1, panelLayout.getHeaderClass(), panelLayout.getHeaderStyle());
            writer.endElement("tr");
        }
        writer.endElement("table");
    }

    protected void renderTableCell(FacesContext facesContext, ResponseWriter writer, UIComponent component, int colspan, String styleClass, String style) throws IOException {
        writer.startElement("td", null);
        if (colspan > 0) {
            writer.writeAttribute("colspan", Integer.toString(colspan), null);
        }
        if (styleClass != null) {
            writer.writeAttribute("class", styleClass, null);
        }
        if (style != null) {
            writer.writeAttribute("style", style, null);
        }
        RendererUtils.renderChild(facesContext, component);
        writer.endElement("td");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

