/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.tree2;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.myfaces.custom.tree2.TreeNode;

public class TreeModel {
    private static final String SEPARATOR = String.valueOf(':');
    private TreeNode root;
    private TreeNode currentNode;

    public TreeModel(TreeNode root) {
        this.root = root;
    }

    public TreeNode getNode() {
        return this.currentNode;
    }

    public void setNodeId(String nodeId) {
        if (nodeId == null) {
            this.currentNode = null;
            return;
        }
        this.currentNode = this.getNodeById(nodeId);
    }

    public String[] getPathInformation(String nodeId) {
        if (nodeId == null) {
            throw new IllegalArgumentException("Cannot determine parents for a null node.");
        }
        ArrayList<String> pathList = new ArrayList<String>();
        pathList.add(nodeId);
        while (nodeId.lastIndexOf(SEPARATOR) != -1) {
            nodeId = nodeId.substring(0, nodeId.lastIndexOf(SEPARATOR));
            pathList.add(nodeId);
        }
        String[] pathInfo = new String[pathList.size()];
        int i = 0;
        while (i < pathInfo.length) {
            pathInfo[i] = (String)pathList.get(pathInfo.length - i - 1);
            ++i;
        }
        return pathInfo;
    }

    public boolean isLastChild(String nodeId) {
        TreeNode parentNode;
        if (nodeId.lastIndexOf(SEPARATOR) == -1) {
            return true;
        }
        String parentId = nodeId.substring(0, nodeId.lastIndexOf(SEPARATOR));
        String childString = nodeId.substring(nodeId.lastIndexOf(SEPARATOR) + 1);
        int childId = Integer.parseInt(childString);
        return childId + 1 == (parentNode = this.getNodeById(parentId)).getChildCount();
    }

    private TreeNode getNodeById(String nodeId) {
        TreeNode node = this.root;
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(nodeId, SEPARATOR);
        sb.append(st.nextToken()).append(SEPARATOR);
        while (st.hasMoreTokens()) {
            int nodeIndex = Integer.parseInt(st.nextToken());
            sb.append(nodeIndex);
            try {
                node = (TreeNode)node.getChildren().get(nodeIndex);
            }
            catch (IndexOutOfBoundsException e) {
                String msg = "Node with id " + sb.toString() + ". Failed to parse " + nodeId;
                throw new IllegalArgumentException(msg);
            }
            sb.append(SEPARATOR);
        }
        return node;
    }
}

