/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html.util;

public abstract class HTMLEncoder {
    public static String encode(String string) {
        return HTMLEncoder.encode(string, false, true);
    }

    public static String encode(String string, boolean encodeNewline) {
        return HTMLEncoder.encode(string, encodeNewline, true);
    }

    public static String encode(String string, boolean encodeNewline, boolean encodeSubsequentBlanksToNbsp) {
        if (string == null) {
            return "";
        }
        StringBuffer sb = null;
        int i = 0;
        while (i < string.length()) {
            String app = null;
            char c = string.charAt(i);
            switch (c) {
                case '\"': {
                    app = "&quot;";
                    break;
                }
                case '&': {
                    app = "&amp;";
                    break;
                }
                case '<': {
                    app = "&lt;";
                    break;
                }
                case '>': {
                    app = "&gt;";
                    break;
                }
                case ' ': {
                    if (!encodeSubsequentBlanksToNbsp || i != 0 && (i - 1 < 0 || string.charAt(i - 1) != ' ')) break;
                    app = "&#160;";
                    break;
                }
                case '\n': {
                    if (!encodeNewline) break;
                    app = "<br/>";
                    break;
                }
                case '\u00e4': {
                    app = "&auml;";
                    break;
                }
                case '\u00c4': {
                    app = "&Auml;";
                    break;
                }
                case '\u00f6': {
                    app = "&ouml;";
                    break;
                }
                case '\u00d6': {
                    app = "&Ouml;";
                    break;
                }
                case '\u00fc': {
                    app = "&uuml;";
                    break;
                }
                case '\u00dc': {
                    app = "&Uuml;";
                    break;
                }
                case '\u00df': {
                    app = "&szlig;";
                    break;
                }
                case '\u20ac': {
                    app = "&euro;";
                    break;
                }
                case '\u00ab': {
                    app = "&laquo;";
                    break;
                }
                case '\u00bb': {
                    app = "&raquo;";
                    break;
                }
                case '\u00a0': {
                    app = "&#160;";
                    break;
                }
                default: {
                    if (c < '\u0080') break;
                    app = "&#" + c + ";";
                }
            }
            if (app != null) {
                if (sb == null) {
                    sb = new StringBuffer(string.substring(0, i));
                }
                sb.append(app);
            } else if (sb != null) {
                sb.append(c);
            }
            ++i;
        }
        if (sb == null) {
            return string;
        }
        return sb.toString();
    }
}

