package org.seasar.nazuna;

import org.seasar.util.Assertion;
import org.seasar.util.StringUtil;

public abstract class AbstractVariableExp implements Expression {

    protected final String[] _names;

    public AbstractVariableExp(final String name) {
    	Assertion.assertNotNull("name", name);
        
        String s = name;
        if (s.startsWith("\"")) {
            s = s.substring(1);
        }
        if (s.endsWith("\"")) {
            s = s.substring(0, s.length() - 1);
        }
        _names = StringUtil.split(s, ".");
    }    
}
