package org.seasar.nazuna;

import org.seasar.util.Assertion;
import org.seasar.util.SeasarException;

public final class InExp implements BooleanExpression {

    private Expression _targetExp;
    private Expression[] _inExps;

    public InExp(Expression targetExp, Expression[] inExps) {
    	Assertion.assertNotNull("targetExp", targetExp);
    	Assertion.assertNotNull("inExps", inExps);

        _targetExp = targetExp;
        _inExps = inExps;
    }

    public boolean evaluate(RuleContext ruleContext) throws SeasarException {
        Comparable target = (Comparable) _targetExp.evaluateValue(ruleContext);
        if (target == null) {
            return false;
        }
        for (int i = 0; i < _inExps.length; i++) {
            Expression inArgExp = _inExps[i];
            Comparable inArg = (Comparable) inArgExp.evaluateValue(ruleContext);
            if (inArg != null && target.compareTo(inArg) == 0) {
                return true;
            }
        }
        return false;
    }
}
