package org.seasar.nazuna.amf;

import java.math.BigDecimal;

import org.seasar.util.Conversion;

public final class AMFUtil {

	private AMFUtil() {
	}

	public static final Object adjustValue(Object value, Class valueClass) {
		if (valueClass.isPrimitive()) {
			if (valueClass == Integer.TYPE) {
				return Conversion.toInteger(value);
			} else if (valueClass == Double.TYPE) {
				return Conversion.toDouble(value);
			} else if (valueClass == Long.TYPE) {
				return Conversion.toLong(value);
			}
		} else {
			if (valueClass == Integer.class) {
				return Conversion.toInteger(value);
			} else if (valueClass == BigDecimal.class) {
				return Conversion.toBigDecimal(value);
			} else if (valueClass == Long.class) {
				return Conversion.toLong(value);
			} else if (valueClass == Double.class) {
				return Conversion.toDouble(value);
			}
		}
		return value;
	}
}
