package test.org.seasar.nazuna;

import java.util.ArrayList;
import java.util.List;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.nazuna.BooleanExp;
import org.seasar.nazuna.BooleanExpression;
import org.seasar.nazuna.CaseExp;
import org.seasar.nazuna.Expression;
import org.seasar.nazuna.NazunaUtil;
import org.seasar.nazuna.StringExp;

public class CaseExpTest extends TestCase {

    public CaseExpTest(String name) {
        super(name);
    }

    public void testEvaluate() throws Exception {
        List boolExpList = new ArrayList();
        List expList = new ArrayList();
        boolExpList.add(new BooleanExp(false));
        expList.add(new StringExp("111"));
        boolExpList.add(new BooleanExp(true));
        expList.add(new StringExp("222"));
        BooleanExpression[] boolExps = NazunaUtil.toBooleanExpressionArray(boolExpList);
        Expression[] exps = NazunaUtil.toExpressionArray(expList);
        Expression exp = new CaseExp(boolExps, exps);
        assertEquals("1", "222", exp.evaluateValue(null));
    }
    
    public void testEvaluate2() throws Exception {
        List boolExpList = new ArrayList();
        List expList = new ArrayList();
        boolExpList.add(new BooleanExp(false));
        expList.add(new StringExp("111"));
        BooleanExpression[] boolExps = NazunaUtil.toBooleanExpressionArray(boolExpList);
        Expression[] exps = NazunaUtil.toExpressionArray(expList);
        Expression exp = new CaseExp(boolExps, exps);
        assertEquals("1", null, exp.evaluateValue(null));
    }
    
    public void testEvaluate3() throws Exception {
        List boolExpList = new ArrayList();
        List expList = new ArrayList();
        boolExpList.add(new BooleanExp(true));
        expList.add(new StringExp("111"));
        boolExpList.add(new BooleanExp(true));
        expList.add(new StringExp("222"));
        BooleanExpression[] boolExps = NazunaUtil.toBooleanExpressionArray(boolExpList);
        Expression[] exps = NazunaUtil.toExpressionArray(expList);
        Expression exp = new CaseExp(boolExps, exps);
        assertEquals("1", "111", exp.evaluateValue(null));
    }
    
    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite ( ) {
        return new TestSuite(CaseExpTest.class);
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.main(new String[]{CaseExpTest.class.getName()});
    }
}