package test.org.seasar.nazuna;

import java.lang.reflect.Method;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.seasar.nazuna.NazunaTransAttribute;
import org.seasar.util.Reflector;
import org.seasar.util.SeasarContext;
import org.seasar.util.SeasarException;

import test.org.seasar.transaction.TransactionTestCase;

public class NazunaTransAttributeTest extends TransactionTestCase {

	private Method _method = Reflector.getMethod(getClass(), "isTx", null);
	
    public NazunaTransAttributeTest(String name) {
        super(name);
    }
    
    public boolean isTx() throws SeasarException {
    	return SeasarContext.getInstance().hasTransaction();
    }
    
    public void testGetInstance() throws Exception {
    	assertEquals("1", NazunaTransAttribute.SUPPORTS, NazunaTransAttribute.getInstance(null));
    	assertEquals("2", NazunaTransAttribute.SUPPORTS, NazunaTransAttribute.getInstance("Supports"));
    	assertEquals("3", NazunaTransAttribute.REQUIRED, NazunaTransAttribute.getInstance("Required"));
    	assertEquals("4", NazunaTransAttribute.REQUIRES_NEW, NazunaTransAttribute.getInstance("RequiresNew"));
    	assertEquals("5", NazunaTransAttribute.MANDATORY, NazunaTransAttribute.getInstance("Mandatory"));
    }
    
    public void testSupports() throws Exception {
    	assertEquals("1", false, isTx());
    	Boolean ret = (Boolean) NazunaTransAttribute.SUPPORTS.invoke(_method, this, null);
    	assertEquals("2", false, isTx());
    	assertEquals("3", false, ret.booleanValue());
    }
    
    public void testRequired() throws Exception {
    	assertEquals("1", false, isTx());
    	Boolean ret = (Boolean) NazunaTransAttribute.REQUIRED.invoke(_method, this, null);
    	assertEquals("2", false, isTx());
    	assertEquals("3", true, ret.booleanValue());
    }
    
    public void testRequired2() throws Exception {
    	assertEquals("1", false, isTx());
    	SeasarContext.getInstance().begin();
    	Boolean ret = null;
    	boolean b = false;
    	try {
    	 	ret = (Boolean) NazunaTransAttribute.REQUIRED.invoke(_method, this, null);
    	 	b = isTx();
    	} finally {
			SeasarContext.getInstance().commit();
    	}
    	assertEquals("2", false, isTx());
    	assertEquals("3", true, b);
    	assertEquals("4", true, ret.booleanValue());
    }
    
    public void testRequiresNew() throws Exception {
    	assertEquals("1", false, isTx());
    	Boolean ret = (Boolean) NazunaTransAttribute.REQUIRES_NEW.invoke(_method, this, null);
    	assertEquals("2", false, isTx());
    	assertEquals("3", true, ret.booleanValue());
    }
    
    public void testMandatory() throws Exception {
    	assertEquals("1", false, isTx());
		SeasarContext.getInstance().begin();
    	Boolean ret = null;
    	boolean b = false;
    	try {
    	 	ret = (Boolean) NazunaTransAttribute.MANDATORY.invoke(_method, this, null);
    	 	b = isTx();
    	} finally {
			SeasarContext.getInstance().commit();
    	}
    	assertEquals("2", false, isTx());
    	assertEquals("3", true, b);
    	assertEquals("4", true, ret.booleanValue());
    }
    
    public void testMandatory2() throws Exception {
    	assertEquals("1", false, isTx());
    	try {
    	 	NazunaTransAttribute.MANDATORY.invoke(_method, this, null);
    	 	fail("1");
    	} catch (Exception ex) {
    		System.out.println(ex);
    	}
    }

    protected void setUp() throws Exception {
    	super.setUp();
    }

    protected void tearDown() throws Exception {
    	super.tearDown();
    }

    public static Test suite ( ) {
        return new TestSuite(NazunaTransAttributeTest.class);
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.main(new String[]{NazunaTransAttributeTest.class.getName()});
    }
}