package test.org.seasar.nazuna;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.nazuna.ResultType;
import org.seasar.nazuna.ResultTypeBuilder;

public class ResultTypeTest extends TestCase {

    public ResultTypeTest(String name) {
        super(name);
    }
    
    public void testGetPropertyNames() throws Exception {
    	String xmlFileName = "/test/org/seasar/nazuna/Employee.xml";
    	ResultType resultType = ResultTypeBuilder.parse(xmlFileName);
    	String[] propertyNames = resultType.getPropertyNames();
    	assertEquals("1", 8, propertyNames.length);
    	assertEquals("2", "EmployeeNo", propertyNames[0]);
    }
    
    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite ( ) {
        return new TestSuite(ResultTypeTest.class);
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.main(new String[]{ResultTypeTest.class.getName()});
    }
}