package test.org.seasar.nazuna;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.nazuna.SortDesc;
import org.seasar.util.SMap;

public class SortDescTest extends TestCase {

	private List _source;
	private Map _item1;
	private Map _item2;
	private Map _item3;
	
    public SortDescTest(String name) {
        super(name);
    }
    
    public void testSort() throws Exception {
    	SortDesc sortDesc = new SortDesc("c");
    	List ret = sortDesc.sort(_source);
    	assertSame("1", _item1, ret.get(0));
    	assertSame("2", _item3, ret.get(1));
    	assertSame("3", _item2, ret.get(2));
    }
    
    public void testSort2() throws Exception {
    	SortDesc sortDesc = new SortDesc("c asc");
    	List ret = sortDesc.sort(_source);
    	assertSame("1", _item1, ret.get(0));
    	assertSame("2", _item3, ret.get(1));
    	assertSame("3", _item2, ret.get(2));
    }
    
    public void testSort3() throws Exception {
    	SortDesc sortDesc = new SortDesc("c desc");
    	List ret = sortDesc.sort(_source);
    	assertSame("1", _item2, ret.get(0));
    	assertSame("2", _item3, ret.get(1));
    	assertSame("3", _item1, ret.get(2));
    }
    
    public void testSort4() throws Exception {
    	SortDesc sortDesc = new SortDesc("a,b");
    	List ret = sortDesc.sort(_source);
    	assertSame("1", _item1, ret.get(0));
    	assertSame("2", _item3, ret.get(1));
    	assertSame("3", _item2, ret.get(2));
    }
    
    public void testSort5() throws Exception {
    	SortDesc sortDesc = new SortDesc("a desc,b asc");
    	List ret = sortDesc.sort(_source);
    	assertSame("1", _item2, ret.get(0));
    	assertSame("2", _item1, ret.get(1));
    	assertSame("3", _item3, ret.get(2));
    }
    
    protected void setUp() throws Exception {
    	_source = new ArrayList();
    	_item1 = new SMap();
    	_item1.put("a", "a1");
    	_item1.put("b", "b1");
    	_item1.put("c", "c1");
    	_source.add(_item1);
    	_item2 = new SMap();
    	_item2.put("a", "a3");
    	_item2.put("b", "b1");
    	_item2.put("c", "c3");
    	_source.add(_item2);
    	_item3 = new SMap();
    	_item3.put("a", "a1");
    	_item3.put("b", "b2");
    	_item3.put("c", "c2");
    	_source.add(_item3);
    	
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite ( ) {
        return new TestSuite(SortDescTest.class);
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.main(new String[]{SortDescTest.class.getName()});
    }
}