package test.org.seasar.transaction;

import junit.framework.*;
import org.seasar.transaction.*;

public class XAResourceManagerTest extends TestCase {

    public XAResourceManagerTest(String name) {
        super(name);
    }

    public void testXAResourceManager() throws Exception {
        assertEquals("1", 0, XAResourceManager.getInstance().getXAResourceCount());
        DefaultXAResource xaRes = new DefaultXAResource();
        XAResourceManager.getInstance().addXAResource(xaRes);
        assertEquals("2", 1, XAResourceManager.getInstance().getXAResourceCount());
        TransactionManagerImpl.getInstance().begin();
        try {
            assertEquals("3", 0, XAResourceManager.getInstance().getXAResourceCount());
        } finally {
            TransactionManagerImpl.getInstance().commit();
        }

        TransactionManagerImpl.getInstance().begin();
        try {
            XAResourceManager.getInstance().addXAResource(xaRes);
            assertEquals("4", DefaultXAResource.RS_ACTIVE, xaRes.getStatus());
        } finally {
            TransactionManagerImpl.getInstance().commit();
        }
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite() {
        return new TestSuite(XAResourceManagerTest.class);
    }

    public static void main(String[] args) {
        junit.textui.TestRunner.main(new String[]{XAResourceManagerTest.class.getName()});
    }
}
