package test.org.seasar.util;

import junit.framework.*;
import java.math.*;
import org.seasar.util.*;

public class ConversionTest extends TestCase {

    public ConversionTest(String name) {
        super(name);
    }

    public void testToNumber() throws Exception {
        assertEquals("1", new Integer(1), Conversion.toNumber("1"));
        assertEquals("2", new Integer(-1), Conversion.toNumber("-1"));
        assertEquals("3", new Integer(Integer.MAX_VALUE), 
        	Conversion.toNumber(String.valueOf(Integer.MAX_VALUE)));
        assertEquals("4", new Integer(Integer.MIN_VALUE), 
        	Conversion.toNumber(String.valueOf(Integer.MIN_VALUE)));
        assertEquals("5", new Long("12345678901"),
        	Conversion.toNumber("12345678901"));
        assertEquals("6", new Long("-12345678901"),
        	Conversion.toNumber("-12345678901"));
        assertEquals("7", new BigDecimal("1.1"), Conversion.toNumber("1.1"));
        assertEquals("8", new BigDecimal("-1.1"), Conversion.toNumber("-1.1"));
        assertEquals("9", new BigDecimal(".1"), Conversion.toNumber(".1"));
        assertEquals("10", new BigDecimal("-.1"), Conversion.toNumber("-.1"));
    }
    
    public void testToByteArray() throws Exception {
        String s = "abc";
        byte[] b = s.getBytes();
        byte[] b2 = Conversion.toByteArray(b);
        assertEquals("1", b.length, b2.length);
        for (int i = 0; i < b.length; i++) {
            assertEquals("2", b[i], b2[i]);
        }
        assertEquals("3", b, Conversion.toByteArray(b));
        assertEquals("4", null, Conversion.toByteArray(null));
    }
    
    public void testToFloat() throws Exception {
        assertEquals("1", new Float(1), Conversion.toFloat("1"));
        assertEquals("2", new Float(1), Conversion.toFloat(new Double(1)));
        assertEquals("3", null, Conversion.toFloat(null));
    }
    
    public void testToShort() throws Exception {
        assertEquals("1", new Short((short) 1), Conversion.toShort("1"));
        assertEquals("2", new Short((short) 1), Conversion.toShort(new Double(1)));
        assertEquals("3", null, Conversion.toShort(null));
    }

    protected void setUp() throws Exception {
    }


    protected void tearDown() throws Exception {
    }


    public static Test suite() {
        return new TestSuite(ConversionTest.class);
    }



    public static void main(String[] args) {
        junit.textui.TestRunner.main(new String[]{ConversionTest.class.getName()});
    }
}
