package org.seasar.nazuna;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

import org.seasar.util.Assertion;
import org.seasar.util.SeasarException;

public abstract class ResultType {

	protected Class _resultClass;
	protected List _tempPropertyTypeList = new ArrayList();
	protected PropertyType[] _propertyTypes;
	protected String[] _propertyNames;

	public ResultType(Class resultClass) {
		Assertion.assertNotNull("resultClass", resultClass);

		_resultClass = resultClass;
	}

	public final Class getResultClass() {
		return _resultClass;
	}

	public final void addPropertyType(PropertyType propertyType) {
		_tempPropertyTypeList.add(propertyType);
	}

	public final void addPropertyTypeDone() {
		_propertyTypes =
			(PropertyType[]) _tempPropertyTypeList.toArray(
				new PropertyType[_tempPropertyTypeList.size()]);
		_tempPropertyTypeList.clear();
		_tempPropertyTypeList = null;
		_propertyNames = new String[_propertyTypes.length];
		for (int i = 0; i < _propertyTypes.length; ++i) {
			_propertyNames[i] = _propertyTypes[i].getName();
		}
	}

	public final int getPropertyTypeSize() {
		return _propertyTypes.length;
	}

	public final PropertyType getPropertyType(int index) {
		return _propertyTypes[index];
	}

	public final String[] getPropertyNames() {
		return _propertyNames;
	}

	public abstract void addPropertyType(
		String propertyName,
		String columnName,
		String typeName);

	public abstract List fetch(ResultSet rs) throws SeasarException;
}