package org.seasar.nazuna;

import java.io.File;
import java.net.URL;

import org.seasar.util.ElementHandler;
import org.seasar.util.SeasarException;
import org.seasar.util.XMLHandler;
import org.seasar.util.XMLHandlerParser;
import org.seasar.util.XMLHandlerRule;
import org.xml.sax.Attributes;

public final class SqletBuilder {

    private static XMLHandlerRule _xmlHandlerRule = new NazunaXMLHandlerRule();

	static {
		configure();
	}
	
	private static void configure() {
        setupXMLHandlerRule();
    }
	
    private SqletBuilder() {
    }

    public static final Sqlet parse(final String path) {
        return (Sqlet) XMLHandlerParser.parse(path, _xmlHandlerRule, false);
    }
    
    public static final Sqlet parse(final URL url) {
        return (Sqlet) XMLHandlerParser.parse(url, _xmlHandlerRule, false);
    }
    
    public static final Sqlet parse(final File file) {
        return (Sqlet) XMLHandlerParser.parse(file, _xmlHandlerRule, false);
    }

    private static void setupXMLHandlerRule() {
        _xmlHandlerRule.addElementHandler("sqlet",
            new ElementHandler() {
                public void start(XMLHandler xmlHandler, Attributes attributes) {
                	String contextName = attributes.getValue("contextName");
                	String resultPath = attributes.getValue("result");
                	Sqlet sqlet = new Sqlet(contextName, resultPath);
                	String transAttributeName = attributes.getValue("transAttribute");
                	NazunaTransAttribute transAttribute = NazunaTransAttribute.getInstance(transAttributeName);
                	sqlet.setTransAttribute(transAttribute);
                    xmlHandler.push(sqlet);
                }
                public void appendBody(XMLHandler xmlHandler, String body) {
                    RuleStatementContainer container = (RuleStatementContainer) xmlHandler.peek();
                    try {
                    	container.addRuleStatement(new TextTag(container, xmlHandler.getLocationDetailPath(), body));
                    } catch (SeasarException ex) {
                		ex.convertSeasarRuntimeException();
                	}
                }
                public void end(final XMLHandler xmlHandler, final String body) {
	            	Sqlet sql = (Sqlet) xmlHandler.peek();
	            	sql.addRuleStatementDone();
                }
            });
        _xmlHandlerRule.addElementHandler("where",
            new ElementHandler() {
            	public void start(XMLHandler xmlHandler, Attributes attributes) {
            		RuleStatementContainer container =
                    	(RuleStatementContainer) xmlHandler.peek();
                    WhereTag whereTag = new WhereTag(container,
                    	xmlHandler.getLocationDetailPath());
                	container.addRuleStatement(whereTag);
                	xmlHandler.push(whereTag);
                }
                public void end(final XMLHandler xmlHandler, final String body) {
                	WhereTag whereTag = (WhereTag) xmlHandler.pop();
                	whereTag.addRuleStatementDone();
                }
            });
     	_xmlHandlerRule.addElementHandler("and",
            new ElementHandler() {
                public void end(final XMLHandler xmlHandler, final String body) {
                	try {
                		RuleStatementContainer container =
	                    	(RuleStatementContainer) xmlHandler.peek();
	                    WhereChildTag andTag = new WhereChildTag(container,
	                    	xmlHandler.getLocationDetailPath(), "AND ", body);
                    	container.addRuleStatement(andTag);
                    } catch (SeasarException ex) {
                		ex.convertSeasarRuntimeException();
                	}
                }
            });
    	_xmlHandlerRule.addElementHandler("or",
            new ElementHandler() {
                public void end(final XMLHandler xmlHandler, final String body) {
                	try {
                		RuleStatementContainer container =
	                    	(RuleStatementContainer) xmlHandler.peek();
	                    WhereChildTag andTag = new WhereChildTag(container,
	                    	xmlHandler.getLocationDetailPath(), "OR ", body);
                    	container.addRuleStatement(andTag);
                    } catch (SeasarException ex) {
                		ex.convertSeasarRuntimeException();
                	}
                }
            });
    }
}
