package org.seasar.nazuna.unit;

import org.seasar.util.Reflector;
import org.seasar.util.SeasarContext;

import junit.framework.TestCase;

public class NazunaTestCase extends TestCase {

	private SeasarContext _context;

	public NazunaTestCase(String name) {
		super(name);
		setupContext();
	}

	public void runBare() throws Throwable {
		preSetUp();
		try {
			setUp();
			try {
				runTest();
			} finally {
				tearDown();
			}
		} finally {
			postTearDown();
		}
	}

	protected void preSetUp() throws Throwable {
		_context.begin();
	}

	protected void postTearDown() throws Throwable {
		_context.rollback();
	}
	
	private void setupContext() {
		String contextName = null;
		try {
			contextName = (String) Reflector.getFieldValue(getClass(), "CONTEXT_NAME");
		} catch (Throwable ignore) {
		}
		_context = SeasarContext.getInstance(contextName);
	}
}