package org.seasar.util;

import org.seasar.message.MessageFormatter;

public class SeasarRuntimeException extends RuntimeException {

    private String _messageCode;
    private Object[] _arguments;
    private String _className;
    private String _methodName;
    private String _message;

	public SeasarRuntimeException(String messageCode) {
        this(messageCode, ArrayUtil.EMPTY_OBJECTS, (Throwable) null);
    }
    
    public SeasarRuntimeException(String messageCode, Object arg0) {
        this(messageCode, new Object[]{arg0}, (Throwable) null);
    }
    
    public SeasarRuntimeException(String messageCode, Object arg0, Object arg1) {
        this(messageCode, new Object[]{arg0, arg1}, (Throwable) null);
    }
    
    public SeasarRuntimeException(String messageCode, Object arg0, Object arg1,
    		Object arg2) {
    			
        this(messageCode, new Object[]{arg0, arg1, arg2}, (Throwable) null);
    }
    
    public SeasarRuntimeException(String messageCode, Object arg0, Object arg1,
    		Object arg2, Object arg3) {
    			
        this(messageCode, new Object[]{arg0, arg1, arg2, arg3}, (Throwable) null);
    }
    
    public SeasarRuntimeException(String messageCode, Object arg0, Object arg1,
    		Object arg2, Object arg3, Object arg4) {
    			
        this(messageCode, new Object[]{arg0, arg1, arg2, arg3, arg4}, (Throwable) null);
    }
    
    public SeasarRuntimeException(String messageCode, Throwable cause) {
        this(messageCode, ArrayUtil.EMPTY_OBJECTS, cause);
    }
    
    public SeasarRuntimeException(String messageCode, Object arg0, Throwable cause) {
        this(messageCode, new Object[]{arg0}, cause);
    }
    
    public SeasarRuntimeException(String messageCode, Object arg0, Object arg1,
    		Throwable cause) {
    			
        this(messageCode, new Object[]{arg0, arg1}, cause);
    }
    
    public SeasarRuntimeException(String messageCode, Object arg0, Object arg1,
    		Object arg2, Throwable cause) {
    			
        this(messageCode, new Object[]{arg0, arg1, arg2}, cause);
    }
    
    public SeasarRuntimeException(String messageCode, Object arg0, Object arg1,
    		Object arg2, Object arg3, Throwable cause) {
    			
        this(messageCode, new Object[]{arg0, arg1, arg2, arg3}, cause);
    }
    
    public SeasarRuntimeException(String messageCode, Object arg0, Object arg1,
    		Object arg2, Object arg3, Object arg4, Throwable cause) {
    			
        this(messageCode, new Object[]{arg0, arg1, arg2, arg3, arg4}, cause);
    }

    public SeasarRuntimeException(final String messageCode, final Object[] arguments) {
        this(messageCode, arguments, null, SeasarRuntimeException.class);
    }
    
    public SeasarRuntimeException(final String messageCode, final Object[] arguments,
    		final Class callerClass) {
    			
        this(messageCode, arguments, null, callerClass);
    }

    public SeasarRuntimeException(final String messageCode, final Object[] arguments,
            final Throwable cause) {

        this(messageCode, arguments, cause, SeasarRuntimeException.class);
    }
    
    public SeasarRuntimeException(final String messageCode, final Object[] arguments,
            final Throwable cause, final Class callerClass) {

        super(cause);
        if (messageCode == null) {
            throw new IllegalArgumentException(MessageFormatter.getMessage("ESSR0007", new Object[]{"messageCode"}));
        }
        _messageCode = messageCode;
        _arguments = arguments;
        _message = MessageFormatter.getMessage(_messageCode, _arguments);
        StackTraceElement ste = ThrowableUtil.getCallerCallerStackTraceElement(
        	this, callerClass);
        _className = ste.getClassName();
        _methodName = ste.getMethodName();
    }

    SeasarRuntimeException(final String messageCode, final Object[] arguments, final Throwable cause,
            final String className, final String methodName,
            final String message) {

        _messageCode = messageCode;
        _arguments = arguments;
        initCause(cause);
        _className = className;
        _methodName = methodName;
        _message = message;
    }

    public static SeasarRuntimeException convertSeasarRuntimeException(
            final Throwable throwable) {

        return convertSeasarRuntimeException("ESSR0017", new Object[]{throwable}, throwable);
    }

    public static SeasarRuntimeException convertSeasarRuntimeException(
            final String messageCode, final Object[] arguments, Throwable throwable) {

        if (throwable instanceof SeasarRuntimeException) {
            return (SeasarRuntimeException) throwable;
        }
        if (throwable instanceof SeasarException) {
            return ((SeasarException) throwable).convertSeasarRuntimeException();
        }
        return new SeasarRuntimeException(messageCode, arguments, throwable);
    }

    public String getMessage() {
        return _message;
    }

    public String getLocalizedMessage() {
        return _message;
    }

    public String getMessageCode() {
        return _messageCode;
    }

    public Object[] getArguments() {
        return _arguments;
    }

    public String getClassName() {
        return _className;
    }

    public String getMethodName() {
        return _methodName;
    }
}