package test.org.seasar.nazuna;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.nazuna.Expression;
import org.seasar.nazuna.GreaterThanExp;
import org.seasar.nazuna.IntegerExp;
import org.seasar.nazuna.NullExp;

public class GreaterThanExpTest extends TestCase {

    public GreaterThanExpTest(String name) {
        super(name);
    }

    public void testEvaluate() throws Exception {
    	String s = "1234567890";
    	String s2 = "1234567891";
        Integer i = new Integer(s);
        Integer i2 = new Integer(s2);
        IntegerExp iExp = new IntegerExp(i);
        IntegerExp i2Exp = new IntegerExp(i2);
        GreaterThanExp gtExp = new GreaterThanExp(iExp, iExp);
        assertEquals("1", false, gtExp.evaluate(null));
        
        GreaterThanExp gt2Exp = new GreaterThanExp(i2Exp, iExp);
        assertEquals("2", true, gt2Exp.evaluate(null));
        
        GreaterThanExp gt3Exp = new GreaterThanExp(iExp, i2Exp);
        assertEquals("3", false, gt3Exp.evaluate(null));
        
        Expression nullExp = new NullExp();
        GreaterThanExp gt4Exp = new GreaterThanExp(iExp, nullExp);
        assertEquals("4", false, gt4Exp.evaluate(null));
        
        GreaterThanExp gt5Exp = new GreaterThanExp(nullExp, iExp);
        assertEquals("5", false, gt5Exp.evaluate(null));
        
        GreaterThanExp gt6Exp = new GreaterThanExp(nullExp, nullExp);
        assertEquals("6", false, gt6Exp.evaluate(null));
   	}

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite ( ) {
        return new TestSuite(GreaterThanExpTest.class);
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.main(new String[]{GreaterThanExpTest.class.getName()});
    }
}