package test.org.seasar.nazuna;

import java.util.HashMap;
import java.util.Map;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.nazuna.ArgType;
import org.seasar.nazuna.Flowlet;
import org.seasar.nazuna.InputType;
import org.seasar.nazuna.RuleContext;
import org.seasar.nazuna.RuleContextImpl;
import org.seasar.nazuna.TextTagFragment;

public class TextTagFragmentTest extends TestCase {

    public TextTagFragmentTest(String name) {
        super(name);
    }
    
    public void testParse() throws Exception {
    	Flowlet rule = new Flowlet();
    	InputType inputType = new InputType();
    	ArgType argType = new ArgType("empno", Integer.class);
    	ArgType argType2 = new ArgType("deptno", Integer.class);
    	inputType.addArgType(argType);
    	inputType.addArgType(argType2);
    	rule.setInputType(inputType);
    	
    	String text = "empno = ${empno} and deptno = ${deptno}";
    	TextTagFragment[] fragments = TextTagFragment.parse(text);
    	Map parameters = new HashMap();
    	parameters.put("empno", new Integer(7788));
    	parameters.put("deptno", new Integer(10));
    	RuleContext ctx = new RuleContextImpl(rule, parameters);
    	fragments[0].execute(ctx);
    	assertEquals("1", "empno = ", ctx.getText());
    	fragments[1].execute(ctx);
    	assertEquals("2", "empno = 7788", ctx.getText());
    	fragments[2].execute(ctx);
    	assertEquals("3", "empno = 7788 and deptno = ", ctx.getText());
    	fragments[3].execute(ctx);
    	assertEquals("4", "empno = 7788 and deptno = 10", ctx.getText());
    }
    
    public void testParse2() throws Exception {
    	Flowlet rule = new Flowlet();
    	InputType inputType = new InputType();
    	ArgType argType = new ArgType("ename", String.class);
    	inputType.addArgType(argType);
    	rule.setInputType(inputType);
    	
    	String text = "ename = '${ename}'";
    	TextTagFragment[] fragments = TextTagFragment.parse(text);
    	Map parameters = new HashMap();
    	parameters.put("ename", "SCOTT");
    	RuleContext ctx = new RuleContextImpl(rule, parameters);
    	fragments[0].execute(ctx);
    	assertEquals("1", "ename = '", ctx.getText());
    	fragments[1].execute(ctx);
    	assertEquals("2", "ename = 'SCOTT", ctx.getText());
    	fragments[2].execute(ctx);
    	assertEquals("3", "ename = 'SCOTT'", ctx.getText());
    }
    
    public void testAdjustToken() throws Exception {
    	assertEquals("1", "sal > 3000", TextTagFragment.adjustToken("sal gt 3000"));
    	assertEquals("2", "ename = 'ab gt cd'", TextTagFragment.adjustToken("ename eq 'ab gt cd'"));
    	assertEquals("3", "ename = '' and aaa > 3000", TextTagFragment.adjustToken("ename eq '' and aaa gt 3000"));
    	assertEquals("4", "ename = 'aaa' and aaa > 3000", TextTagFragment.adjustToken("ename eq 'aaa' and aaa gt 3000"));
    	assertEquals("5", "ename = '''ab gt cd'", TextTagFragment.adjustToken("ename eq '''ab gt cd'"));
    	assertEquals("6", "", TextTagFragment.adjustToken(""));
    	assertEquals("7", "aaa", TextTagFragment.adjustToken("aaa"));
    }
    
    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite ( ) {
        return new TestSuite(TextTagFragmentTest.class);
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.main(new String[]{TextTagFragmentTest.class.getName()});
    }
}