package test.org.seasar.system;

import java.lang.reflect.Method;

import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.seasar.system.JMXService;
import org.seasar.system.JMXUtil;
import org.seasar.system.MBeanMetaData;
import org.seasar.util.EMap;
import org.seasar.util.SeasarException;

public class JMXServiceTest extends JMXTestCase {
		
	public JMXServiceTest(String name) {
    	super(name);
  	}

  	public void testInvoke() throws Throwable {    	
    	assertEquals("1", "hello", JMXService.invoke(HelloMBean.NAME, "greeting", null, null));
    }
    
    public void testGetMBean() throws Throwable {    	
    	assertNotNull("1", JMXService.getMBean(HelloMBean.NAME));
    }
    
    public void testRegisterMBean() throws Throwable {
    	try {
    		JMXService.registerMBean("dummy", JMXUtil.getMBeanName("Dummy"));
    		fail("1");
    	} catch (SeasarException ex) {
    		System.out.println(ex);
    	}
    }
    
    public void testUnregisterMBean() throws Throwable {    	
    	JMXService.unregisterMBean(HelloMBean.NAME);
    	assertEquals("1", false, JMXService.isRegistered(HelloMBean.NAME));
    }
    
    public void testNotify() throws Throwable {    	
    	Notify notify = new Notify();
    	JMXService.registerMBean(notify, NotifyMBean.NAME);
    	NotificationListenerTester listener = new NotificationListenerTester();
    	JMXService.addNotificationListener(NotifyMBean.NAME, listener);
    	notify.sendMessage("Hello");
    	assertEquals("1", true, listener.isCalled());
    	JMXService.removeNotificationListener(NotifyMBean.NAME, listener);
    }
    
    public void testSpike() throws Throwable {    	
    	MBeanServer server = MBeanServerFactory.createMBeanServer();
    	EMap mbeans = new EMap();
    	Hello hello = new Hello();
    	server.registerMBean(hello, JMXUtil.getObjectName(HelloMBean.NAME));
    	mbeans.put(HelloMBean.NAME, hello);
    	int num = 100000;
    	long start = System.currentTimeMillis();
    	for (int i = 0; i < num; i++) {
    		server.invoke(JMXUtil.getObjectName(HelloMBean.NAME), "greeting", null, null);
    	}
    	System.out.println("MBeanServer:" + (System.currentTimeMillis() - start));
    	
    	start = System.currentTimeMillis();
    	for (int i = 0; i < num; i++) {
    		Object mbean = mbeans.get(HelloMBean.NAME);
    		Method m = MBeanMetaData.getInstance(mbean.getClass()).getMethod("greeting", null);
    		m.invoke(mbean, null);
    	}
    	System.out.println("MBeanMetaData:" + (System.currentTimeMillis() - start));
    }

  	protected void setUp() throws Exception {
  		super.setUp();
  		Hello hello = new Hello();
    	JMXService.registerMBean(hello, HelloMBean.NAME);
  	}

	protected void tearDown() throws Exception {
		super.tearDown();
  	}

  	public static Test suite ( ) {
    	return new TestSuite(JMXServiceTest.class);
  	}

  	public static void main (String[] args) {
    	junit.textui.TestRunner.main(new String[]{JMXServiceTest.class.getName()});
  	}
}