package test.org.seasar.util;

import junit.framework.*;
import java.util.*;
import org.seasar.util.*;

public class EArrayListTest extends TestCase {

    private EArrayList _list;

    public EArrayListTest(String name) {
        super(name);
    }

    public void testAdd() throws Exception {
        assertTrue("1", _list.add("1"));
        assertEquals("2", 1, _list.size());
        _list.add(0, "2");
        assertEquals("3", "2", _list.get(0));
        assertEquals("4", 2, _list.size());

        try {
            _list.add(-1, null);
            fail("5");
        } catch (Exception ex) {
            System.out.println(ex.toString());
        }
        _list.add(_list.size(), null);
        try {
            _list.add(_list.size() + 1, null);
            fail("6");
        } catch (Exception ex) {
            System.out.println(ex.toString());
        }
    }


    public void testAddAll() throws Exception {
        _list.add("1");
        _list.add("2");
        List l = new ArrayList();
        assertTrue("1", !_list.addAll(l));
        l.add("3");
        l.add(null);
        assertTrue("2", _list.addAll(l));
        assertEquals("3", "3", _list.get(2));
        assertEquals("4", 4, _list.size());

        assertTrue("5", _list.addAll(0, l));
        assertEquals("6", "3", _list.get(0));
        assertEquals("7", 6, _list.size());
        _list.add(_list.size(), l);
        try {
            _list.add(_list.size() + 1, l);
            fail("8");
        } catch (Exception ex) {
            System.out.println(ex.toString());
        }

        List list2 = new EArrayList();
        List list3 = new ArrayList();
        List list4 = new ArrayList();
        list3.add("1");
        list2.addAll(list3);
        list2.addAll(list4);
    }

    public void testRemove() throws Exception {
        _list.add("1");
        _list.add("2");
        assertEquals("1", "1", _list.remove(0));
        assertEquals("2", 1, _list.size());
        try {
            _list.remove(-1);
            fail("3");
        } catch (Exception ex) {
            System.out.println(ex.toString());
        }
        try {
            _list.remove(1);
            fail("4");
        } catch (Exception ex) {
            System.out.println(ex.toString());
        }
    }

    public void testRemoveAll() throws Exception {
        _list.add("1");
        _list.add("2");
        List l = new ArrayList();
        assertTrue("1", !_list.removeAll(l));
        l.add("1");
        l.add(null);
        assertTrue("2", _list.removeAll(l));
        assertEquals("3", 1, _list.size());
    }

    public void testGet() throws Exception {
        _list.add("1");
        _list.add("2");
        assertEquals("1", "1", _list.get(0));
        assertEquals("2", "2", _list.get(1));
        try {
            _list.get(-1);
            fail("3");
        } catch (Exception ex) {
            System.out.println(ex.toString());
        }
        try {
            _list.get(2);
            fail("4");
        } catch (Exception ex) {
            System.out.println(ex.toString());
        }
    }

    public void testRetainAll() throws Exception {
        _list.add("1");
        _list.add("2");
        List l = new ArrayList();
        l.add("1");
        l.add("2");
        assertTrue("1", !_list.retainAll(l));
        assertEquals("2", 2, _list.size());

        l.set(1, null);
        assertTrue("3", _list.retainAll(l));
        assertEquals("4", "1", _list.get(0));
        assertEquals("5", 1, _list.size());
    }

    public void testClear() throws Exception {
        _list.add("1");
        _list.add("2");
        _list.clear();
        assertEquals("1", 0, _list.size());
        _list.clear();
        assertEquals("2", 0, _list.size());
    }

    public void testSet() throws Exception {
        _list.add("1");
        _list.set(0, "2");
        assertEquals("1", "2", _list.get(0));
        try {
            _list.set(-1, null);
            fail("2");
        } catch (Exception ex) {
            System.out.println(ex);
        }
        _list.set(2, "aaa");
        assertEquals("3", null, _list.get(1));
        assertEquals("4", "aaa", _list.get(2));
        assertEquals("5", 3, _list.size());
    }

    public void testConstructor() throws Exception {
        List l = new ArrayList();
        l.add("1");
        l.add("2");
        List l2 = new EArrayList(l);
        assertEquals("1", "1", l2.get(0));
        assertEquals("2", "2", l2.get(1));
        assertEquals("3", 2, l2.size());
    }

    public void testTrimeToSize() throws Exception {
        _list.add("1");
        _list.add("2");
        _list.trimToSize();
        assertEquals("1", 2, _list.getCapacity());
    }

    public void testSize() throws Exception {
        _list.add("1");
        _list.add("2");
        assertEquals("1", 2, _list.size());
    }

    public void testIsEmpty() throws Exception {
        assertTrue("1", _list.isEmpty());
        _list.add("1");
        assertTrue("2", !_list.isEmpty());
    }

    public void testContains() throws Exception {
        _list.add("1");
        _list.add("2");
        assertTrue("1", _list.contains("1"));
        assertTrue("2", !_list.contains("3"));
    }

    public void testContainsAll() throws Exception {
        _list.add("1");
        _list.add("2");
        List l = new ArrayList();
        l.add("1");
        l.add("2");
        assertTrue("1", _list.containsAll(l));
        l.add("3");
        assertTrue("2", !_list.containsAll(l));
    }

    public void testIndexOf() throws Exception {
        _list.add("1");
        _list.add(null);
        _list.add("1");
        _list.add(null);
        assertEquals("1", 0, _list.indexOf("1"));
        assertEquals("2", 1, _list.indexOf(null));
        assertEquals("3", -1, _list.indexOf("2"));
    }

    public void testLastIndexOf() throws Exception {
        _list.add("1");
        _list.add(null);
        _list.add("1");
        _list.add(null);
        assertEquals("1", 2, _list.lastIndexOf("1"));
        assertEquals("2", 3, _list.lastIndexOf(null));
        assertEquals("3", -1, _list.lastIndexOf("2"));
    }

    public void testEquals() throws Exception {
        _list.add("1");
        _list.add("2");
        _list.add(null);
        List l = new ArrayList();
        l.add("1");
        l.add("2");
        l.add(null);
        assertEquals("1", l, _list);
        l.add("3");
        assertTrue("2", !_list.equals(l));
        _list.add("4");
        assertTrue("3", !_list.equals(l));
    }

    public void testClone() throws Exception {
        _list.add("1");
        _list.add("2");
        _list.add(null);
        List l = (List) _list.clone();
        assertEquals("1", l, _list);
        assertTrue("2", _list != l);
    }

    public void testToArray() throws Exception {
        _list.add("1");
        _list.add("2");
        _list.add(null);
        Object[] a = _list.toArray();
        assertEquals("1", "1", a[0]);
        assertEquals("2", "2", a[1]);
        assertEquals("3", null, a[2]);
        assertEquals("4", 3, a.length);

        String[] a2 = new String[0];
        a2 = (String[]) _list.toArray(a2);
        assertEquals("5", "1", a2[0]);
        assertEquals("6", "2", a2[1]);
        assertEquals("7", null, a2[2]);
        assertEquals("8", 3, a2.length);

        String[] a3 = new String[10];
        a3 = (String[]) _list.toArray(a3);
        assertEquals("9", "1", a3[0]);
        assertEquals("10", "2", a3[1]);
        assertEquals("11", null, a3[2]);
        assertEquals("12", 10, a3.length);
    }

    public void testIterator() throws Exception {
        _list.add("1");
        _list.add("2");
        Iterator i = _list.iterator();
        assertEquals("1", "1", i.next());
        assertEquals("2", "2", i.next());
        assertTrue("3", !i.hasNext());
        for (Iterator i2 = _list.iterator(); i2.hasNext(); ) {
            i2.next();
            i2.remove();
        }
        assertEquals("4", 0, _list.size());
    }
    
    public void testListIterator() throws Exception {
        _list.add("1");
        _list.add("2");
        ListIterator i = _list.listIterator();
        assertEquals("1", "1", i.next());
        assertEquals("2", 1, i.nextIndex());
        assertEquals("3", 0, i.previousIndex());
        assertEquals("4", "1", i.previous());
        i.remove();
        assertEquals("5", 0, i.nextIndex());
        assertEquals("6", -1, i.previousIndex());
        assertEquals("7", "2", i.next());
        assertTrue("8", !i.hasNext());
        assertTrue("9", i.hasPrevious());
        i.set("3");
        assertEquals("10", "3", i.previous());
        i.add("4");
        assertEquals("11", "4", i.previous());
        assertEquals("12", "4", i.next());
        assertEquals("13", "3", i.next());
        assertEquals("14", 2, _list.size());

        ListIterator i2 = _list.listIterator(_list.size());
        assertEquals("15", "3", i2.previous());
        assertEquals("16", "4", i2.previous());
        assertTrue("17", !i2.hasPrevious());
    }

    public void testSubList() throws Exception {
        _list.add("1");
        _list.add("2");
        _list.add("3");
        _list.add("4");
        List l = _list.subList(1, 4);
        assertEquals("1", 3, l.size());
        assertEquals("2", "2", l.get(0));
        assertEquals("3", "4", l.get(2));

        List l2 = l.subList(0, 2);
        assertEquals("4", 2, l2.size());
        assertEquals("5", "2", l2.get(0));
        assertEquals("6", "3", l2.get(1));
    }

    public void testPerformance() throws Exception {
        int num = 1000000;
        List al = new ArrayList();
        EArrayList eal = new EArrayList();

        long start = System.currentTimeMillis();
        for (int i = 0; i < num; i++) {
            al.add("aaa");
        }
        System.out.println("ArrayList.add:" + (System.currentTimeMillis() - start));

        start = System.currentTimeMillis();
        for (int i = 0; i < num; i++) {
            eal.add("aaa");
        }
        System.out.println("EArrayList.add:" + (System.currentTimeMillis() - start));

        start = System.currentTimeMillis();
        for (int i = 0; i < num; i++) {
            al.get(i);
        }
        System.out.println("ArrayList.get:" + (System.currentTimeMillis() - start));

        start = System.currentTimeMillis();
        for (int i = 0; i < num; i++) {
            eal.get(i);
        }
        System.out.println("EArrayList.get:" + (System.currentTimeMillis() - start));

        start = System.currentTimeMillis();
        for (Iterator i = al.iterator(); i.hasNext(); ) {
            i.next();
        }
        System.out.println("ArrayList iteration:" + (System.currentTimeMillis() - start));

        start = System.currentTimeMillis();
        for (Iterator i = eal.iterator(); i.hasNext(); ) {
            i.next();
        }
        System.out.println("EArrayList iteration:" + (System.currentTimeMillis() - start));

//        if (true) {
//            return;
//        }
        start = System.currentTimeMillis();
        Serializer.serialize(al);
        System.out.println("ArrayList serialize:" + (System.currentTimeMillis() - start));

        start = System.currentTimeMillis();
        Serializer.serialize(eal);
        System.out.println("EArrayList serialize:" + (System.currentTimeMillis() - start));

        int removeNum = 100;
        start = System.currentTimeMillis();
        for (int i = 0; i < removeNum; i++) {
            al.remove(0);
        }
        System.out.println("ArrayList.remove:" + (System.currentTimeMillis() - start));

        start = System.currentTimeMillis();
        for (int i = 0; i < removeNum; i++) {
            eal.remove(0);
        }
        System.out.println("EArrayList.remove:" + (System.currentTimeMillis() - start));
    }


    /**
     *  The JUnit setup method
     *
     *@exception  Exception  Description of the Exception
     */
    protected void setUp() throws Exception {
        _list = new EArrayList();
    }


    /**
     *  The teardown method for JUnit
     *
     *@exception  Exception  Description of the Exception
     */
    protected void tearDown() throws Exception {
        _list = null;
    }


    /**
     *  A unit test suite for JUnit
     *
     *@return    The test suite
     */
    public static Test suite() {
        return new TestSuite(EArrayListTest.class);
    }


    /**
     *  The main program for the EArrayListTest class
     *
     *@param  args  The command line arguments
     */
    public static void main(String[] args) {
        junit.textui.TestRunner.main(new String[]{EArrayListTest.class.getName()});
    }
}
