package test.org.seasar.util;

import junit.framework.*;
import org.seasar.util.*;
import test.org.seasar.sql.*;

public class SeasarContextTest extends ConnectionPoolTestCase {

    private SeasarContext _seasarContext;

    public SeasarContextTest(String name) {
        super(name);
    }

    public void testLookup() throws Exception {
        assertEquals(_seasarContext.lookup("javax.transaction.UserTransaction"),
                _seasarContext.lookup("javax.transaction.UserTransaction"));
    }

    public void testLookupNoCache() throws Exception {
        assertTrue(_seasarContext.lookupNoCache("jdbc/oracle") !=
                _seasarContext.lookupNoCache("jdbc/oracle"));
    }

    public void testGetDataSource() throws Exception {
        assertNotNull(_seasarContext.getDataSource());
    }

    public void testGetConnection() throws Exception {
        assertNotNull(_seasarContext.getConnection());
    }

    public void testGetUserTransaction() throws Exception {
        assertNotNull(_seasarContext.getUserTransaction());
    }

    public void testTransaction() throws Exception {
        _seasarContext.begin();
        _seasarContext.commit();
        _seasarContext.begin();
        _seasarContext.rollback();
    }

    public void testGetInitialContext() throws Exception {
        assertNotNull(_seasarContext.getInitialContext());
    }

    public void testSerialize() throws Exception {
        _seasarContext.getDataSource();
        _seasarContext.getUserTransaction();
        Serializer.serialize(_seasarContext);
    }
    
    public void testGetHostNameAndPort() throws Exception {
    	SeasarContext ctx = SeasarContext.getInstance("test");
        String hostName = ctx.getHostName();
        int port = ctx.getPort();
        assertNotNull("1", hostName);
        assertEquals("2", 1118, port);
        System.out.println("hostName:" + hostName + ",port:" + port);
    }

	public void testGetInstance() throws Exception {
        assertNotNull("1", SeasarContext.getInstance(null));
    }

    protected void setUp() throws Exception {
    	super.setUp();
        _seasarContext = SeasarContext.getInstance();
    }

    protected void tearDown() throws Exception { 
    	super.tearDown();
    }

    public static Test suite() {
        return new TestSuite(SeasarContextTest.class);
    }

    public static void main(String[] args) {
        junit.textui.TestRunner.main(new String[]{SeasarContextTest.class.getName()});
    }
}
