// Copyright 2002 Macromedia, Inc. and its licensors.  All Rights Reserved.
//
// Use and/or redistribution of this file, in whole or in part, is subject
// to the Macromedia Sample Files License, which was distributed with this file.
//
//
/*

Focuser class


	The purpose of this class is to provide a simple object that can remember a
	field to set focus on.  It's used in conjunction with message boxes to set
	focus when a message box closes.


	The class is meant to be used as singleton- it shouldn't be instantiated
	and all access should go through the _global.focuser.

	This file is a pure ActionScript object that manipulates movieclip
	instances set at runtime.

	#include info for this file:

			FLA:				main.fla

			Layer:				Actions : Class Definitions

			Frame:				1

			Library Symbol:		N/A

			Library Path:		N/A


*/
//

//----------------------------------------------------------------------
//Focuser 
//----------------------------------------------------------------------
function Focuser () {
}

_global.focuser = new Focuser();

// Sets the focusee movie clip which is the movie
// clip that should get focus when 
//
// 		_global.focuser.focus()
//
// 	is called.
//
// 	Returns this so that focusee can be set at the same time focuser is passed
// 	to function.
Focuser.prototype.setFocusee = function(focusee_mc) {
	this.focusee_mc = focusee_mc;
	return this;
}

Focuser.prototype.focus =function() {
	Selection.setFocus(this.focusee_mc);
}
//Authors: Brian Kruse (bkruse), Buck Bito (bbito)
