// Copyright 2002 Macromedia, Inc. and its licensors.  All Rights Reserved.
//
// Use and/or redistribution of this file, in whole or in part, is subject
// to the Macromedia Sample Files License, which was distributed with this file.
//
#initclip 
//
//
/*
//
ProfileUI class

	The ProfileUI class encapsulates all UI behavior of the profile section of the
	checkout.

	This code is meant to initialize the section and provide uniform access
	to the profile data object.

	This file is associated with a library movie clip symbol.

	#include info for this file:

			FLA:				main.fla

			Layer:				Actions : Class

			Frame:				1

			Library Symbol:		profileFldsOpenContent_mc

			Library Path:		CheckoutWidget/profileFlds/profileFldsOpenContent_mc
//
*/
//

//----------------------------------------------------------------------
//ProfileUI
//
// As with all the CheckoutUI classes, this class encapsulates the 
// behaviour of the "open" state of this checkout widget.
//
// The "closed" state of this widget can be referenced via:
//
// 	this._parent.summaryContent_mc
//
//----------------------------------------------------------------------
function ProfileUI() {
}

// Associate the ProfileUI class with the authortime profileFldsOpenContent_mc
// instance.

Object.registerClass("ProfileUISymbol", ProfileUI);

ProfileUI.prototype = new MovieClip();

//----------------------------------------------------------------------
// init
//----------------------------------------------------------------------
ProfileUI.prototype.init = function(tabController, firstTab, strings, checkout, user) {
	this.checkout = checkout;
	this.user = user;
	this.strings = strings;
	var tabCount = firstTab;
	this.hint_txt.text = strings.PROFILE_FLDS_HINT_str;
	this.emailFld_mc.label_txt.text = strings.EMAIL_LBL_str;
	this.emailFld_mc.statusIcon_mc.gotoAndStop("required");
	this.newCustomer_true_rb.setLabel(strings.NEW_CUSTOMER_TRUE_RB_LBL_str);
	this.newCustomer_false_rb.setLabel(strings.NEW_CUSTOMER_FALSE_RB_LBL_str);
	// Set the focusRectOuter to white so we the focus rectangle around radio
	// buttons appears to be invisible.  Radio button focus rectangles look
	// strange in this application's UI.
	this.newCustomer_rg.setStyleProperty("focusRectOuter", 0xFFFFFF);
	this.newCustomer_rg.setChangeHandler("setNewCustomer", this);
	this.passwordFld_mc.label_txt.text = strings.PASSWORD_LBL_str;
	this.passwordFld_mc.input_txt.password = true;
	this.passwordFld_mc.statusIcon_mc.gotoAndStop("required");
	this.passwordConfirmFld_mc.label_txt.text = strings.PASSWORD_CONFIRM_LBL_str;
	this.passwordConfirmFld_mc.input_txt.password = true;
	this.passwordConfirmFld_mc.statusIcon_mc.gotoAndStop("required");
	_global.sizeAndFormatIconBtn(this.continue_ib, this.strings.CREATE_ACCOUNT_BTN_LBL_str, _global.formIconBtnFormat);
	this.continue_ib.setChangeHandler("validateAndNotifyCheckout", this);
	tabController.setTab("ProfileUI", this.newCustomer_true_rb, tabCount++);
	tabController.setTab("ProfileUI", this.newCustomer_false_rb, tabCount++);
	tabController.setTab("ProfileUI", this.emailFld_mc.input_txt, tabCount++);
	tabController.setTab("ProfileUI", this.passwordFld_mc.input_txt, tabCount++);
	tabController.setTab("ProfileUI", this.passwordConfirmFld_mc.input_txt, tabCount++);
	tabController.setTab("ProfileUI", this.continue_ib, tabCount++);
	this.continue_ib.tabIndex = tabCount++;

}


//----------------------------------------------------------------------
// getEmailValidator
//
// 	This function is used for validator access so that the email 
// 	validator is created exactly once, but only if needed.
//----------------------------------------------------------------------
ProfileUI.prototype.getEmailValidator = function() {
	if(this.emailValidator == undefined) {
		this.emailValidator = new ValidateEmail(50, this.strings.VALIDATE_EMAIL_ERR_MSG_str);
	}
	return this.emailValidator;
}


//----------------------------------------------------------------------
// copyToSummary
//
// 	This function is called after the widget's been validated and is
// 	collapsing.
//----------------------------------------------------------------------
ProfileUI.prototype.copyToSummary = function()
{
	var summary_txt = this._parent.summaryContent_mc.summary_txt;
	var summaryMsg_str = _global.appStrings.EMAIL_LBL_str + " " + this.emailFld_mc.input_txt.text;
	summary_txt.text = summaryMsg_str;
	this.checkout.initSwitchUserUI();
}

//----------------------------------------------------------------------
// opening
//
// 	This function is called when the UI widget is opening.
//----------------------------------------------------------------------
ProfileUI.prototype.opening = function() {
	Selection.setFocus(this.newCustomer_rg.getValue() ? 
					this.newCustomer_true_rb : this.newCustomer_false_rb);
}

//----------------------------------------------------------------------
// setNewCustomer
//
// 	This is the change handler for the radio buttons.
//----------------------------------------------------------------------
ProfileUI.prototype.setNewCustomer = function (calledBy)
{
	if(calledBy.getValue()){
		this.passwordConfirmFld_mc._visible = true;
		_global.sizeAndFormatIconBtn(this.continue_ib, this.strings.CREATE_ACCOUNT_BTN_LBL_str, _global.formIconBtnFormat);
	}
	else{
		this.passwordConfirmFld_mc._visible = false;
		_global.sizeAndFormatIconBtn(this.continue_ib, this.strings.LOGIN_BTN_LBL_str, _global.formIconBtnFormat);
	}
}

//----------------------------------------------------------------------
// loginFailed
//----------------------------------------------------------------------
ProfileUI.prototype.loginFailed = function (title, explanation) {
	_global.errorBox(title, 
			explanation, "focus", _global.focuser.setFocusee(this.emailFld_mc.input_txt));
	this.emailFld_mc.statusIcon_mc.gotoAndStop("error");
	this.passwordConfirmFld_mc.statusIcon_mc.gotoAndStop("error");
	this.passwordFld_mc.statusIcon_mc.gotoAndStop("error");
}

ProfileUI.prototype.validateAndNotifyCheckout = function() {
	if (this.validate()) {
		this.checkout.initUser(this.newCustomer_rg.getValue(), this.emailFld_mc.input_txt.text,
				this.passwordFld_mc.input_txt.text);
	}
}

//----------------------------------------------------------------------
// validate
//
// 	All of the fields have a status icon with two frames: "required" and
// 	"error".  By moving the playhead for those clips, we can give feedback.
//
// 	This function should return a boolean indicating whether the
// 	validation was successful.
//----------------------------------------------------------------------
ProfileUI.prototype.validate = function() {
	this.passwordConfirmFld_mc.statusIcon_mc.gotoAndStop("required");
	this.passwordFld_mc.statusIcon_mc.gotoAndStop("required");
	this.emailFld_mc.statusIcon_mc.gotoAndStop("required");
	var isValid = true;
	var email = ValidatorClass.prototype.trim(this.emailFld_mc.input_txt.text);
	this.emailFld_mc.input_txt.text = email;
	var pass = ValidatorClass.prototype.trim(this.passwordFld_mc.input_txt.text);
	this.passwordFld_mc.input_txt.text = pass;
	var confirm = ValidatorClass.prototype.trim(this.passwordConfirmFld_mc.input_txt.text);
	this.passwordConfirmFld_mc.input_txt.text = confirm;
	if(!this.getEmailValidator().validate(email)) {
		isValid = false;
		_global.errorBox(this.strings.VALIDATE_EMAIL_ERR_TITLE_str, 
				this.getEmailValidator().getFailedValidationMessage(), 
				"focus", _global.focuser.setFocusee(this.emailFld_mc.input_txt));
		this.emailFld_mc.statusIcon_mc.gotoAndStop("error");
	}
	else {
		if(pass.length < 4) {
			isValid = false;
			_global.errorBox(this.strings.VALIDATE_PASS_ERR_TITLE_str,
				this.strings.VALIDATE_PASS_INVALID_ERR_MSG_str, "focus", 
				_global.focuser.setFocusee(this.passwordFld_mc.input_txt));
			this.passwordFld_mc.statusIcon_mc.gotoAndStop("error");
		}
		if(this.newCustomer_rg.getValue()) {
			if(pass != confirm) {
				isValid = false;
				_global.errorBox(this.strings.VALIDATE_PASS_ERR_TITLE_str, 
						this.strings.VALIDATE_PASS_MISMATCH_ERR_MSG_str, "focus", 
						_global.focuser.setFocusee(this.passwordFld_mc.input_txt));
				this.passwordConfirmFld_mc.statusIcon_mc.gotoAndStop("error");
				this.passwordFld_mc.statusIcon_mc.gotoAndStop("error");
			}
		}
	}
	return isValid;
}

#endinitclip 
//Authors: Brian Kruse (bkruse), Buck Bito (bbito)
