// Copyright 2002 Macromedia, Inc. and its licensors.  All Rights Reserved.
//
// Use and/or redistribution of this file, in whole or in part, is subject
// to the Macromedia Sample Files License, which was distributed with this file.
//
#initclip 
//
//
/*
//
ShippingFieldsUI class

	The ShippingFieldsUI class encapsulates all UI behavior of the ShippingFields
	section of the checkout.

	This code is meant to initialize the section and provide a uniform access
	to the ShippingFields data object.

	This file is associated with a library movie clip symbol.

	#include info for this file:

			FLA:				main.fla

			Layer:				Actions : Class

			Frame:				1

			Library Symbol:		ShippingFldsOpenContent_mc

			Library Path:		CheckoutWidget/shippingFlds/shippingFldsOpenContent_mc
//
*/
//

//----------------------------------------------------------------------
//ShippingFieldsUI
//
// As with all the CheckoutUI classes, this class encapsulates the 
// behaviour of the "open" state of this checkout widget.
//
// The "closed" state of this widget can be referenced via:
//
// 	this._parent.summaryContent_mc
//
//----------------------------------------------------------------------
function ShippingFieldsUI() {
}

// Associate the ShippingFieldsUI class with the authortime
// shippingFldsOpenContent_mc instance
Object.registerClass("ShippingFieldsUISymbol", ShippingFieldsUI);

ShippingFieldsUI.prototype = new MovieClip();

//----------------------------------------------------------------------
// init
//----------------------------------------------------------------------
ShippingFieldsUI.prototype.init = function(tabController, firstTab, strings, checkout) {
	this.checkout = checkout;
	var tabCount = firstTab;
	this.hint_txt.text = strings.SHIPPING_FLDS_HINT_str;
	this.useBillingForShipping_ch.setLabel(strings.USE_BILLING_FOR_SHIPPING_CH_LBL_str);
	this.useBillingForShipping_ch.controller = this;
	tabController.setTab("ShippingFieldsUI", this.useBillingForShipping_ch, tabCount++);
	tabController.setTab("ShippingFieldsUI", this.firstNameFld_mc.input_txt, tabCount++);
	tabController.setTab("ShippingFieldsUI", this.lastNameFld_mc.input_txt, tabCount++);
	tabController.setTab("ShippingFieldsUI", this.country_cb, tabCount++);
	tabController.setTab("ShippingFieldsUI", this.addressFld_mc.input_txt, tabCount++);
	tabController.setTab("ShippingFieldsUI", this.cityFld_mc.input_txt, tabCount++);
	tabController.setTab("ShippingFieldsUI", this.state_cb, tabCount++);
	tabController.setTab("ShippingFieldsUI", this.zipCodeFld_mc.input_txt, tabCount++);
	tabController.setTab("ShippingFieldsUI", this.phoneFld_mc.input_txt, tabCount++);
	tabController.setTab("ShippingFieldsUI", this.continue_ib, tabCount++);
	checkout.applyAddressFldLabels(this);
	_global.sizeAndFormatIconBtn(this.continue_ib, strings.CONTINUE_BTN_LBL_str, _global.formIconBtnFormat);
}


//----------------------------------------------------------------------
// copyToSummary
//
// 	This function is called after the widget's been validated and is
// 	collapsing.
//----------------------------------------------------------------------
ShippingFieldsUI.prototype.copyToSummary = function()
{
	var summaryMsg_str = this.firstNameFld_mc.input_txt.text + " " +  this.lastNameFld_mc.input_txt.text + newline;
	summaryMsg_str += this.addressFld_mc.input_txt.text + newline;
	summaryMsg_str += this.cityFld_mc.input_txt.text + ", " + this.state_cb.getValue() + "  " + this.country_cb.getValue() + "  " + this.zipCodeFld_mc.input_txt.text + newline;
	summaryMsg_str += this.phoneFld_mc.input_txt.text;
	this._parent.summaryContent_mc.summary_txt.text = summaryMsg_str;
}

//----------------------------------------------------------------------
// opening
//
// 	This function is called when the UI widget is opening.
//----------------------------------------------------------------------
ShippingFieldsUI.prototype.opening = function() {
	Selection.setFocus(this.firstNameFld_mc.input_txt);
}

//----------------------------------------------------------------------
// validate
//
// 	Because billing fields and shipping fields validate identically,
// 	the code is shared in the checkout class.
//----------------------------------------------------------------------
ShippingFieldsUI.prototype.validate = function() {
	return this.checkout.validateAddresses(this);
}

#endinitclip 
//Authors: Brian Kruse (bkruse), Buck Bito (bbito)
