// Copyright 2002 Macromedia, Inc. and its licensors.  All Rights Reserved.
//
// Use and/or redistribution of this file, in whole or in part, is subject
// to the Macromedia Sample Files License, which was distributed with this file.
//
#initclip 1
//
//
/*
//
HistoryUI class

	The HistoryUI class encapsulates all UI behavior pertaining to maintaining a history of
	a browsing session.

	This is meant to be used as a singleton: i.e. It's not meant to be
	instantiated directly and all access should go through the _global.history_mc
	object.

	This file is associated with a library movie clip symbol.

	#include info for this file:

			FLA:				main.fla

			Layer:				Actions : Class

			Frame:				1

			Library Symbol:		historyWidget_mc

			Library Path:		widgetGroup/historyWidget/historyWidget_mc
//
*/
//

//----------------------------------------------------------------------
//HistoryUI
//----------------------------------------------------------------------
function HistoryUI() {
	_global.history_mc = this;
}

// Associate the HistoryUI class with the authortime historyWidget_mc instance
Object.registerClass("HistorySymbol", HistoryUI);


HistoryUI.prototype = new MovieClip();

//----------------------------------------------------------------------
// init
//----------------------------------------------------------------------
HistoryUI.prototype.init = function(toolTip_mc, tabController, strings, catalog) {
	this.toolTip_mc = toolTip_mc;
	this.tabController = tabController;
	this.strings = strings;
	this.catalog = catalog;
	this.isOpen = false;
	this.openContent_mc.history_lb.setItemSymbol("FPCCatColorListItemSymbol");
	this.openContent_mc.history_lb.measureItmHgt();
	_global.sizeAndFormatListBox(this.openContent_mc.history_lb, 12);
	this.openContent_mc.history_lb.setChangeHandler("gotoProduct", this);
	this.widgetLabel_txt.text = this.strings.HISTORY_WIDGET_LBL_str;
	this.histIcon0_mc.controller = this;
	this.histIcon0_mc._x = this.widgetLabel_txt._x + this.widgetLabel_txt.textWidth + 12
	// add the rest of the history icon MCs
	var i = 1;
	var x = this.histIcon0_mc._x + 2*this.histIcon0_mc._width;
	this.totalIcons = Math.floor((this._width - this.histIcon0_mc._x)/(2*this.histIcon0_mc._width));
	this.activeIcons = 0;
	while(i < this.totalIcons) {
		this.attachMovie("colorSwatch8x8_mc", "histIcon" + i + "_mc", 100+i);
		this["histIcon" + i + "_mc"].controller = this;
		this["histIcon" + i + "_mc"]._x = x;
		this["histIcon" + i + "_mc"]._y = this.histIcon0_mc._y;
		x += 2*this.histIcon0_mc._width;
		i++;
	}
	this.tabController.setTab("HistoryUI", this.headBG_mc,
			TabConstants.prototype.HistoryUIStartTab);
}

HistoryUI.prototype.startListening = function() {
	seasar.event.Broadcaster.addEventListener("browseNewProduct", this);
}

HistoryUI.prototype.browseNewProductPerformed = function(data) {
	this.addRecentItem(data.prod, data.catLabel, data.catColor);
}

HistoryUI.prototype.gotoProduct = function (lb) {
	var productRecord = lb.getSelectedItem().data;
	if(productRecord["CATEGORYOID"] != undefined &&
			productRecord["PRODUCTOID"] != undefined) {
		this.catalog.changeSelectedProduct(productRecord["CATEGORYOID"], 
				productRecord["PRODUCTOID"]);
	}
}

HistoryUI.prototype.addRecentItem = function (productRecord, label, newColor)
{
	if(productRecord["PRODUCTOID"] != undefined) {
		var newLabel = label + ": " + productRecord["NAME"];
		var i = this.totalIcons - 1;
		var l = this.openContent_mc.history_lb.getLength();
		var dupe = false;
		for (i=0; i<l && !dupe; i++){
			if(this.openContent_mc.history_lb.getItemAt(i).label == newLabel){
				dupe = true;
			}
		}
		if(!dupe) {
			this.updateHistIcons(productRecord, newLabel, newColor);
			productRecord.COLOR = newColor;
			this.openContent_mc.history_lb.addItem(newLabel, productRecord);
		}
	}
}

//----------------------------------------------------------------------
// updateHistIcons
//
// 	Add colored icon to collapsed history widget.
//----------------------------------------------------------------------
HistoryUI.prototype.updateHistIcons = function(productRecord, newLabel, newColor)
{
	var i = this.totalIcons - 1;
	var currColor, prevColor;
	var prevIcon_mc;
	while(i > 0) {
		prevIcon_mc = this["histIcon" + Number(i - 1) + "_mc"];
		if(prevIcon_mc.inited) {
			currColor = new Color(this["histIcon" + i + "_mc"]);
			prevColor = new Color(prevIcon_mc);
			currColor.setRGB(prevColor.getRGB());
			if(!this["histIcon" + i + "_mc"].inited) {
				this.initHistIcon(this["histIcon" + i + "_mc"]);
			}
			this["histIcon" + i + "_mc"].catOID = prevIcon_mc.catOID;
			this["histIcon" + i + "_mc"].prodOID = prevIcon_mc.prodOID;
			this["histIcon" + i + "_mc"].tip = prevIcon_mc.tip;
		}
		i--;
	}
	
	if(!this.histIcon0_mc.inited) {
		this.initHistIcon(this.histIcon0_mc);
	}
	this.histIcon0_mc.catOID = productRecord["CATEGORYOID"];
	this.histIcon0_mc.prodOID = productRecord["PRODUCTOID"];
	this.histIcon0_mc.tip = newLabel;
	currColor = new Color(this.histIcon0_mc);
	currColor.setRGB(newColor);
}

//----------------------------------------------------------------------
// initHistIcon
//
// This sets up tool tips as well.
//----------------------------------------------------------------------
HistoryUI.prototype.initHistIcon = function (histIcon_mc) {
	histIcon_mc.inited = true;
	++histIcon_mc.controller.activeIcons;
	histIcon_mc.onPress = HistoryUI.prototype.histIconClicked;
	histIcon_mc.onRollOver = histIcon_mc.onDragOver = HistoryUI.prototype.prepareToolTip;
	histIcon_mc.onRollOut = histIcon_mc.onDragOut = HistoryUI.prototype.hideToolTip;
}


//----------------------------------------------------------------------
// histIconClicked
//
// In function below: this = histIcon_mc.
//----------------------------------------------------------------------
HistoryUI.prototype.histIconClicked = function () {
	this.controller.toolTip_mc.hide();
	this.controller.catalog.changeSelectedProduct(this.catOID, this.prodOID);
}

//----------------------------------------------------------------------
// prepareToolTip
//
// In function below: this = histIcon_mc.
//----------------------------------------------------------------------
HistoryUI.prototype.prepareToolTip = function () {
	this.controller.toolTip_mc.prepare(this, this.tip, this._xmouse, this._ymouse);
	this.onMouseMove = HistoryUI.prototype.moveTip;
}

//----------------------------------------------------------------------
// moveTip
//
// In function below: this = histIcon_mc.
//----------------------------------------------------------------------
HistoryUI.prototype.moveTip = function () {
	this.controller.toolTip_mc.move(this, this._xmouse, this._ymouse);
}
	
//----------------------------------------------------------------------
// hideToolTip
//
// In function below: this = histIcon_mc.
//----------------------------------------------------------------------
HistoryUI.prototype.hideToolTip = function () {
	delete this.onMouseMove;
	this.controller.toolTip_mc.hide();
}

//----------------------------------------------------------------------
// toggleWidget
//
// Called from WidgetGroup.
//----------------------------------------------------------------------
HistoryUI.prototype.toggleWidget = function(isOpening) {
	this.isOpen = isOpening;
	this.tabController.setTab("HistoryUI", this.openContent_mc.history_lb,
		isOpening ?  TabConstants.prototype.HistoryUIStartTab + 1 + this.totalIcons : undefined);
}

#endinitclip
//Authors: Brian Kruse (bkruse), Buck Bito (bbito)
