// Copyright 2002 Macromedia, Inc. and its licensors.  All Rights Reserved.
//
// Use and/or redistribution of this file, in whole or in part, is subject
// to the Macromedia Sample Files License, which was distributed with this file.
//
#initclip 1
/*
 * Description: SpinButtonField constructor - it will inherit directly from
 *					FUIComponent
 *
 * Parameters:  None
 *
 * Return:      None
 *
 * Author:		Bradley Hill - Macromedia
 */
FSpinButtonFieldClass = function() {
    this.init();
}
FSpinButtonFieldClass.prototype = new FUIComponentClass();
Object.registerClass("FSpinButtonFieldSymbol", FSpinButtonFieldClass);

/// --------------
// Class Variables
// ---------------
FSpinButtonFieldClass.DEF_MAX  = 100;
FSpinButtonFieldClass.DEF_MIN  = 0;
FSpinButtonFieldClass.DEF_INT  = 1;
FSpinButtonFieldClass.DEF_RATE = 100;

// -----------------------
// Public Instance Methods
// -----------------------
FSpinButtonFieldClass.prototype.getMaximum = function() { return this.maximum; };

FSpinButtonFieldClass.prototype.getMinimum = function() { return this.minimum; };

FSpinButtonFieldClass.prototype.getInterval = function() { return this.interval; };

FSpinButtonFieldClass.prototype.getRate = function() { return this.rate; };

FSpinButtonFieldClass.prototype.getEditable = function() { return this.editable; };

FSpinButtonFieldClass.prototype.init = function() {
	super.init();
	
	// remove bounding box
	this.boundingBox_mc.unloadMovie();
	this.tabChildren = true;
	
	// grab clip params or defaults
	if (null == this.maximum || isNaN(parseFloat(this.maximum)) || this.maximum < this.minimum) this.maximum = FSpinButtonFieldClass.DEF_MAX;
	if (null == this.minimum || isNaN(parseFloat(this.minimum)) || this.minimum > this.maximum) 
		this.minimum = (FSpinButtonFieldClass.DEF_MIN < this.maximum) ? FSpinButtonFieldClass.DEF_MIN : this.maximum - FSpinButtonFieldClass.DEF_MAX;
	if (null == this.interval || isNaN(parseFloat(this.interval)) || this.interval > this,maximum - this.minimum) this.interval = FSpinButtonFieldClass.DEF_INT;
	if (null == this.rate || isNaN(parseFloat(this.rate)) || 0 > this.rate) 
		this.rate = (FSpinButtonFieldClass.DEF_RATE < this.maximum - this.minimum) ? FSpinButtonFieldClass.DEF_RATE : (this.maximum - this.minimum) / 10;
	this.currentValue = parseFloat(this.startValue);
	if (isNaN(this.currentValue)) this.currentValue = this.minimum;
	
	this.editable = true;
	
	this.controller = this;
	
	// subcomponents dimensions
	this.buttonWidth = 13;
	this.textFieldWidth = this._width - this.buttonWidth;
	this.buttonHeight = this._height / 2;
}

FSpinButtonFieldClass.prototype.setMaximum = function(max) {
	max = parseFloat(max);
	if (isNaN(max) || max < this.minimum) max = this.minimum;
	this.maximum = max;
}

FSpinButtonFieldClass.prototype.setMinimum = function(min) {
	min = parseFloat(min);
	if (isNaN(min) || min > this.maximum ) min = this.maximum;
	this.minimum = min;
}

FSpinButtonFieldClass.prototype.setInterval = function(interval) {
	interval = parseFloat(interval);
	if (isNaN(interval) || interval > this.maximum - this.minimum) return;
	this.interval = interval;
	this.myUpButton._visible = (this.interval) ? true : false;
	this.myDownButton._visible = (this.interval) ? true : false;
}

FSpinButtonFieldClass.prototype.setRate = function(rate) {
	rate = parseFloat(rate);
	if (isNaN(rate) || rate < 0) return;
	this.rate = rate;
}

FSpinButtonFieldClass.prototype.getValue = function() {
	return this.currentValue;
};

FSpinButtonFieldClass.prototype.setValue = function(value) {
	this.myTextField.text = value;
	this.currentValue = parseFloat(value);
	this.currentValue = isNAN(this.currentValue) ? this.minimum : this.currentValue;
}

FSpinButtonFieldClass.prototype.setEditable = function(editable) {
	if (0 == arguments.length) return;
	editable = Boolean(editable);
	if (editable) { 
		with (this.myTextField) {
			type = "input";
			border = true;
			selectable = true;
			restrict = "0-9";
		}
		this.myUpButton._visible = (this.interval) ? true : false;
		this.myDownButton._visible = (this.interval) ? true : false
	} else {
		with (this.myTextField) {
			type = "dynamic";
			border = false;
			selectable = false;
		}
		this.myUpButton._visible = false;
		this.myDownButton._visible = false;
	}
	
	this.editable = editable;
}

FSpinButtonFieldClass.prototype.setChangeHandler = function(handler, obj) {
	if ("string" != typeof handler && null != handler) return;
	this.changeObj = (arguments.length < 2) ? this._parent : obj;
	this.changeHandler = handler;
}

FSpinButtonFieldClass.prototype.getButtons = function() {
	var buttons = new Object();
	buttons.up = this.myUpButton;
	buttons.down = this.myDownButton;
	return buttons;
}

FSpinButtonFieldClass.prototype.setSize = function(w, h) {
	w = parseInt(w);
	h = parseInt(h);
	if (isNaN(w) || w < 0 || isNaN(h) || h < 0) return;
	if (w == this._width && h == this._height) return;
	super.setSize(w, h);
	this.width = w;
	this.height = h;
	this.textFieldWidth = this.width - this.buttonWidth;
	this.addTextField();
	this.myTextField.onKillFocus = function () { this._parent.checkContents(); }
	this.myTextField.embedFonts = this.styleTable["embedFonts"].value;
	this.myTextField.setNewTextFormat(_global.smallTextRight_fmt);
	this.addUpButton();
	this.addDownButton();
}

// -----------------------
// Public Instance Methods
// -----------------------
FSpinButtonFieldClass.prototype.addTextField = function() {
	this.createTextField("myTextField", 1, 0, 0, this.textFieldWidth, this.height);
	with (this.myTextField) {
		type = "input";
		border = true;
		selectable = true;
		text = this.currentValue;
		hscroll = 0;
	}
	this.myTextField.controller = this;
	Key.addListener(this.myTextField);
	this.myTextField.onKeyUp = function() { this.controller.checkForEnter() };
}

FSpinButtonFieldClass.prototype.addUpButton = function() {
	this.attachMovie("FIconButtonSymbol", "myUpButton", 2);
	with (this.myUpButton) {
		_x = this.myTextField._width + 1;
		_y = 0;
		_visible = (this.interval) ? true : false;
	}
	this.myUpButton.setSize(this.buttonWidth, this.buttonHeight);
	this.myUpButton.setBackground("spinUpIconButtonBG_mc");
	
	this.myUpButton.controller = this;
	this.myUpButton.oldOnPress = this.myUpButton.onPress
	this.myUpButton.onPress = function() { this.controller.upPress(); this.oldOnPress(); };
	this.myUpButton.oldOnRelease = this.myUpButton.onRelease;
	this.myUpButton.onRelease = function() { this.controller.btnRelease(); this.oldOnRelease(); };
	this.myUpButton.oldOnReleaseOutside = this.myUpButton.onReleaseOutside;
	this.myUpButton.onReleaseOutside = function() { this.controller.btnRelease(); this.oldOnReleaseOutside(); };
}

FSpinButtonFieldClass.prototype.addDownButton = function() {
	this.attachMovie("FIconButtonSymbol", "myDownButton", 3);
	with (this.myDownButton) {
		_x = this.myTextField._width + 1;
		_y = this.buttonHeight - 1;
		_visible = (this.interval) ? true : false;
	}
	this.myDownButton.setSize(this.buttonWidth, this.buttonHeight);
	this.myDownButton.setBackground("spinDownIconButtonBG_mc");
	
	this.myDownButton.controller = this;
	this.myDownButton.oldOnPress = this.myDownButton.onPress
	this.myDownButton.onPress = function() { this.controller.downPress(); this.oldOnPress(); };
	this.myDownButton.oldOnRelease = this.myDownButton.onRelease;
	this.myDownButton.onRelease = function() { this.controller.btnRelease(); this.oldOnRelease(); };
	this.myDownButton.oldOnReleaseOutside = this.myDownButton.onReleaseOutside;
	this.myDownButton.onReleaseOutside = function() { this.controller.btnRelease(); this.oldOnReleaseOutside(); };
}

FSpinButtonFieldClass.prototype.btnRelease = function() {
	clearInterval(this.controller.intervalID);
}

FSpinButtonFieldClass.prototype.upPress = function() {
	this.controller.changeValue(true);
	this.controller.intervalID = setInterval(this.controller, "changeValue", this.controller.rate, true);
}

FSpinButtonFieldClass.prototype.downPress = function() {
	this.controller.changeValue(false);
	this.controller.intervalID = setInterval(this.controller, "changeValue", this.controller.rate, false);
}

FSpinButtonFieldClass.prototype.changeValue = function(increment) {
	increment = Boolean(increment);
	var oldValue = this.currentValue;
	this.currentValue += (increment) ? this.interval : -this.interval;
	if (increment) {
		this.currentValue = (this.currentValue > this.maximum) ? this.maximum : this.currentValue;
	} else {
		this.currentValue = (this.currentValue < this.minimum) ? this.minimum : this.currentValue;
	}
	if (oldValue != this.currentValue) {
		this.myTextField.text = this.currentValue;
		this.changeObj[this.changeHandler](this, this.currentValue);
	}
}

FSpinButtonFieldClass.prototype.checkContents = function() {
	var value = parseFloat(this.myTextField.text);
	var didChange = (value != this.currentValue) ? true : false;
	if (isNaN(value)) value = this.currentValue;
		value = (value > this.maximum) ? this.maximum : value;
		value = (value < this.minimum) ? this.minimum : value;
		this.currentValue = this.myTextField.text = value;
		this.myTextField.hscroll = 0;
	if (didChange) this.changeObj[this.changeHandler](this, this.currentValue);
}

FSpinButtonFieldClass.prototype.checkForEnter = function() {
	if ((Key.ENTER == Key.getCode()) && (new String(this.myTextField) == Selection.getFocus())) {
		this.checkContents();
	}
}

FSpinButtonFieldClass.prototype.onMouseover = function() {
	
}
/*
// ****** Live Preview SWF *****
	Stage.align = "TL";
	Stage.scaleMode = "noScale";

	function onLoad() {
		spinner.setSize(Stage.width, Stage.height);
	}

	var listen = new Object();
	Stage.addListener(listen);
	listen.onResize = function() {
		spinner.setSize(Stage.width, Stage.height);
	}

	function onUpdate() {
		if (xch.maximum != spinner.maximum) spinner.setMaximum(xch.maximum);
		if (xch.minimum != spinner.minimum) spinner.setMinimum(xch.minimum);
		if (xch.interval != spinner.interval) spinner.setInterval(xch.interval);
		if (xch.rate != spinner.rate) spinner.setRate(xch.rate);
		if (xch.startValue != spinner.getValue()) spinner.setValue(xch.startValue);
	}
*/
#endinitclip
