#include "NetServices.as"
#include "seasar/lang/SObject.as"
#include "seasar/unit/TestCase.as"
#include "seasar/event/Broadcaster.as"
#include "petmarket/service/cart/Cart.as"

if (test.petmarket.service.cart.CartTest === undefined) {
	seasar.lang.SObject.defineClass("test.petmarket.service.cart.CartTest",
		seasar.unit.TestCase, ["cart"]);
	
	var proto = test.petmarket.service.cart.CartTest.prototype;
	
	proto.setUp = function() {
		NetServices.setDefaultGatewayUrl("http://localhost:8080/petmarket/gateway");
		var conn = NetServices.createGatewayConnection();
		this.cart = new petmarket.service.cart.Cart(conn);
	}
	
	proto.tearDown = function() {
		this.cart = null;
	}
	
	proto.testNewCartOid = function() {
		var listener = new Object();
		listener.newCartOidPerformed = function(data) {
			trace("listener.newCartOidPerformed:" + data);
		}
		seasar.event.Broadcaster.addEventListener("newCartOid", listener);
		this.cart.newCartOid();
	}
	
	proto.testGetShippingMethodsServer = function() {
		var listener = new Object();
		listener.getShippingMethodsServerPerformed = function(data) {
			trace("listener.getShippingMethodsServerPerformed:" + data);
		}
		seasar.event.Broadcaster.addEventListener("getShippingMethodsServer", listener);
		this.cart.getShippingMethodsServer();
	}
	
	delete proto;
}