<?php
/**
 * This code was developped by SECIOSS (http://www.secioss.co.jp/).
 *
 *              Copyright (C) 2009 SECIOSS CORPORATION
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation.
 */

require_once("Log.php");

$response_xml = '<?xml version="1.0" encodeing="UTF-8"?>
<response>
  <code>%d</code>
  <userid>%s</userid>
  <idpentityid>%s</idpentityid>
</response>
';

$userid = '';
$idpentityid = '';
$token = '';
$rc = 1;

$conf = parse_ini_file("../../conf/config.ini");

if (isset($_GET['secioss_token'])) {
    $token = $_GET['secioss_token'];
}

if ($token && !preg_match('/[^a-zA-Z0-9]+/', $token)) {
    if (isset($conf['memcache_host'])) {
        $hosts = split(" ", $conf['memcache_host']);
    } else {
        $hosts = array('localhost');
    }

    $memcache = new Memcache;
    foreach ($hosts as $host) {
        $memcache->addServer($host, 11211);
    }

    $info = $memcache->get($token);
    if ($info) {
        $info = unserialize($info);
        if (is_array($info)) {
            if (isset($info['userid'])) {
                $userid = $info['userid'];
            }
            if (isset($info['idpentityid'])) {
                $idpentityid = $info['idpentityid'];
            }
        }
    }

    if ($userid) {
        $rc = 0;
    }
}

printf($response_xml, $rc, $userid, $idpentityid);
?>
