<?php
/**
 * This code was developped by SECIOSS (http://www.secioss.co.jp/).
 *
 *              Copyright (C) 2009 SECIOSS CORPORATION
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation.
 */

require_once("Log.php");
require_once("../../lib/util.php");
require_once("../../lib/openid.php");
require_once("../../lib/message.php");
session_start();

$log = &Log::singleton('syslog', LOG_LOCAL5, 'siscloud');

$back;
$openid;

if (isset($_POST['back'])) {
    $back = $_POST['back'];
} else if (isset($_GET['back'])) {
    $back = $_GET['back'];
}

if (!isset($conf['auth_module']) && (!$back || (isset($conf['trust']) && !preg_match('/'.$conf['trust'].'/', $back)))) {
    $log->err("Invalid URL parameters");
    exit(1);
}

if (isset($_POST['openid_identifier'])) {
    $openid = $_POST['openid_identifier'];
} else {
    display('openid_login.tpl', $back);
}

if (!$openid) {
    display('openid_login.tpl', $back, array(RP_ERR_002));
}

$consumer = getConsumer();
if (Auth_OpenID::isFailure($consumer)) {
    $log->err("OpenID Consumer can't be created: " . $consumer->message);
    display('openid_login.tpl', $back, array(RP_ERR_001));
}

// Begin the OpenID authentication process.
$auth_request = $consumer->begin($openid);

// No auth request means we can't begin OpenID.
if (!$auth_request) {
    $log->err("Authentication error: invalid OpenID");
    display('openid_login.tpl', $back, array(RP_ERR_002));
}

if ($auth_request->shouldSendRedirect()) {
    $redirect_url = $auth_request->redirectURL(getTrustRoot(),
                                               getReturnTo()."?back=".urlencode($back));

    // If the redirect URL can't be built, display an error message.
    if (Auth_OpenID::isFailure($redirect_url)) {
        $log->err("Could not redirect to server: ".$redirect_url->message);
        display('openid_login.tpl', $back, array(RP_ERR_002));
    } else {
        // Send redirect.
        header("Location: ".$redirect_url);
    }
} else {
    // Generate form markup and render it.
    $form_id = 'openid_message';
    $form_html = $auth_request->htmlMarkup(getTrustRoot(), getReturnTo()."?back=".urlencode($back),
                                           false, array('id' => $form_id));

    // Display an error if the form markup couldn't be generated;
    // otherwise, render the HTML.
    if (Auth_OpenID::isFailure($form_html)) {
        $log->err("Could not redirect to server: ".$form_html->message);
        display('openid_login.tpl', $back, array(RP_ERR_002));
    } else {
        print $form_html;
    }
}

?>
