<?php
/**
 * This code was developped by SECIOSS (http://www.secioss.co.jp/).
 *
 *              Copyright (C) 2009 SECIOSS CORPORATION
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation.
 */

require_once "Log.php";
require_once "../../lib/openid.php";
require_once "../../lib/message.php";
session_start();

$conf = parse_ini_file("../../conf/config.ini");

$log = &Log::singleton('syslog', LOG_LOCAL5, 'siscloud');

$redirect_html = '<html>
<body onLoad="document.redirect.submit()">
  <form name="redirect" method="POST" action="%s">
    <input type="hidden" name="secioss_token" value="%s">
  </form>
</body>
</html>';

$back = isset($_GET['back']) ? $_GET['back'] : false;
if (isset($conf['auth_module'] && (!$back || (isset($conf['trust']) && !preg_match('/'.$conf['trust'].'/', $back)))) {
    $log->err("Invalid URL parameters");
    exit(1);
}

$consumer = getConsumer();
if (Auth_OpenID::isFailure($consumer)) {
    $log->err("OpenID Consumer can't be created: " . $consumer->message);
    display('openid_login.tpl', $back, array(RP_ERR_001));
}

// Complete the authentication process using the server's response.
$return_to = getReturnTo();
$response = $consumer->complete($return_to);

// Check the response status.
if ($response->status == Auth_OpenID_CANCEL) {
    $log->err("OpenID verification cancelled");
    display('openid_login.tpl', $back, array(RP_ERR_003));
} else if ($response->status == Auth_OpenID_FAILURE) {
    $log->err("OpenID authentication failed: " . $response->message);
    display('openid_login.tpl', $back, array(RP_ERR_004));
} else if ($response->status == Auth_OpenID_SUCCESS) {
    $user = $response->getDisplayIdentifier();
    if (isset($conf['auth_module'])) {
        $_SERVER['REMOTE_USER'] = $user;
        chdir('../../auth/modules');
        require_once('../../auth/modules/'.$conf['auth_module']);
    } else {
        $info = array('userid' => $user);

        if (isset($conf['memcache_host'])) {
            $hosts = split(" ", $conf['memcache_host']);
        } else {
            $hosts = array('localhost');
        }

        $memcache = new Memcache;
        foreach ($hosts as $host) {
            $memcache->addServer($host, 11211);
        }

        $token = getToken(32);
        if (!$memcache->set($token, serialize($info), 0, 30)) {
            $log->err("Can't set OpenID to memcache");
            display('openid_login.tpl', $back, array(RP_ERR_001));
        }

        $log->notice("OpenID login succeeded for $user");

        print sprintf($redirect_html, $back, $token);
    }
}

?>
