<?php
/**
 * This code was developped by SECIOSS (http://www.secioss.co.jp/).
 *
 *              Copyright (C) 2009 SECIOSS CORPORATION
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation.
 */

require_once("Log.php");
require_once("/usr/share/simplesamlphp/www/_include.php");
require_once("../../lib/util.php");
require_once("../../lib/message.php");

$conf = parse_ini_file("../../conf/config.ini");

$log = &Log::singleton('syslog', LOG_LOCAL5, 'siscloud');

$redirect_html = '<html>
<body onLoad="document.redirect.submit()">
  <form name="redirect" method="POST" action="%s">
    <input type="hidden" name="secioss_token" value="%s">
  </form>
</body>
</html>';

$idpentityid = '';
$back = '';
foreach (array('idpentityid', 'back') as $var) {
    if (isset($_POST[$var])) {
        ${$var} = $_POST[$var];
    } else if (isset($_GET[$var])) {
        ${$var} = $_GET[$var];
    }
}

if (!$idpentityid) {
    $log->err("Invalid URL parameters");
    exit(1);
}
if (!isset($conf['auth_module']) && (!$back || (isset($conf['trust']) && !preg_match('/'.$conf['trust'].'/', $back)))) {
    $log->err("Invalid URL parameters");
    exit(1);
}

$samlconfig = SimpleSAML_Configuration::getInstance();
$session = SimpleSAML_Session::getInstance();

if (!isset($session) || !$session->isValid('saml2') ) {
    SimpleSAML_Utilities::redirect(
        '/' . $samlconfig->getBaseURL() .
        'saml2/sp/initSSO.php',
        array('RelayState' => SimpleSAML_Utilities::selfURL(),
              'idpentityid' => $idpentityid)
      );
}

$attributes = $session->getAttributes();
$user = '';
foreach (array('uid', 'sAMAccountName') as $attr) {
    if (isset($attributes[$attr])) {
        $user = $attributes[$attr][0];
    }
}

if (isset($conf['auth_module'])) {
    $_SERVER['REMOTE_USER'] = $user;
    chdir('../../auth/modules'); 
    require_once('../../auth/modules/'.$conf['auth_module']);
} else {
    $info = array('userid' => $user, 'idpentityid' => $idpentityid);

    if (isset($conf['memcache_host'])) {
        $hosts = split(" ", $conf['memcache_host']);
    } else {
        $hosts = array('localhost');
    }

    $memcache = new Memcache;
    foreach ($hosts as $host) {
        $memcache->addServer($host, 11211);
    }

    $token = getToken(32);
    if (!$memcache->set($token, serialize($info), 0, 30)) {
        $log->err("Can't set SAML userid to memcache");
        display('fatal.tpl', null, RP_ERR_001);
    }

    print sprintf($redirect_html, $back, htmlspecialchars($token));
}

$log->notice("SAML login succeeded for $user");
?>
