#!/usr/bin/python

import os
import sys
import urlparse
import wsgiref.handlers

from google.appengine.ext import webapp
from google.appengine.ext.webapp import template

from session import OpenIDSession
from consumer import OpenIDAuthHandler, OpenIDFinishHandler, OpenIDConfig

_DEBUG = False

class SampleFrontPage(webapp.RequestHandler):
  """Show the default front page."""
  def get(self):
    id = self.request.cookies.get('sissession', None)
    if id:
      session = OpenIDSession()
      session.load(id)
      self.response.out.write('session id: %s<br>' % id)
      self.response.out.write('status: %s' % session.get('status'))
      session.destroy()
    else:
      tenant = self.request.get('tenant')
      self.redirect('/openid/login?tenant=%s' % tenant)

class SampleAdminHandler(webapp.RequestHandler):
  """Administrate OpenID configuration."""
  def get(self):
    tenant = self.request.get('tenant')
    if tenant == '':
      tenant = 'Default'
    configs = OpenIDConfig.gql('where tenant = :1', tenant)

    if configs.count() != 0:
      config = configs[0]
    else:
      config = {}

    values = {
      'config': config,
      'tenant': tenant
    }
    cwd = os.path.dirname(__file__)
    path = os.path.join(cwd, 'templates', 'openid/admin.html')
    self.response.out.write(template.render(path, values))

  def post(self):
    id = self.request.get('id')
    tenant = self.request.get('tenant')
    if tenant == '':
      tenant = 'Default'
    op_url = self.request.get('op_url')
    self.response.out.write('id: %s' % id)
    if id == '':
      config = OpenIDConfig(tenant=tenant)
    else:
      config = OpenIDConfig.get_by_id(long(id))

    config.op_url = op_url
    config.put()

    parts = list(urlparse.urlparse(self.request.uri))
    parts[4] = 'tenant=%s' % tenant
    self.redirect(urlparse.urlunparse(parts))

# Map URLs to our RequestHandler subclasses above
_URLS = [
  ('/', SampleFrontPage),
  ('/openid/login', OpenIDAuthHandler),
  ('/openid/finish', OpenIDFinishHandler),
  ('/openid/admin', SampleAdminHandler)
]

def main(argv):
  application = webapp.WSGIApplication(_URLS, debug=_DEBUG)
  wsgiref.handlers.CGIHandler().run(application)

if __name__ == '__main__':
  main(sys.argv)
