<?php
$logid = 'Menu';

require_once("../lib/util.php");
if (file_exists("../conf/menu.php")) {
    require_once("../conf/menu.php");
}

$error = 0;
$message = '';
$tplfile = 'menu.tpl';

$conf = parse_ini_file("../conf/config.ini", true);
if (empty($conf)) {
     $log->err(logformat("Can't read config.ini"));
     exit(1);
}

if (!isset($conf['password'])) {
     $log->err(logformat("Set password configuration"));
     exit(1);
}

$user = isset($_SERVER['REMOTE_USER']) ? $_SERVER['REMOTE_USER'] : null;

$smarty = new Smarty();
$smarty->template_dir = 'templates';
$smarty->compile_dir = 'templates_c';

$smarty->assign('username', $user);
if (isset($menu)) {
    $allowed_menu = array();
    foreach ($menu as $link) {
        if (!isset($link['tokens']) || preg_match('/(|,)'.$link['tokens'].'(|,)/i', $_SESSION['tokens'])) {
            $allowed_menu[] = $link;
        }
    }
    $smarty->assign('menu', $allowed_menu);
}

$smarty->display($tplfile);
?>
