<?php
require_once('/usr/share/simplesamlphp/www/_include.php');

require_once('SimpleSAML/Utilities.php');
require_once('SimpleSAML/Session.php');
require_once('SimpleSAML/XHTML/Template.php');

/* Load simpleSAMLphp, configuration and metadata */
$config = SimpleSAML_Configuration::getInstance();
$session = SimpleSAML_Session::getInstance();

if (!isset($session) || !$session->isValid('saml2') ) {
  SimpleSAML_Utilities::redirect(
    '/' . $config->getBaseURL() .
    'saml2/sp/initSSO.php',
    array('RelayState' => SimpleSAML_Utilities::selfURL())
    );
}

$attributes = $session->getAttributes();
$data = '';
foreach ($attributes as $key => $values) {
    $data .= ($data ? '#' : '').$key.'='.join(',', $values);
}

$_SERVER['REMOTE_USER'] = $attributes['seciosssystemid'][0];
$_SERVER['REMOTE_USER_DATA'] = base64_encode($data);
?>
