<?php
$logid = 'Profile';

require_once("../lib/util.php");
require_once("Secioss/AutoLogin.php");
require_once("Smarty/Smarty.class.php");
require_once("message.php");
if (file_exists("../conf/menu.php")) {
    require_once("../conf/menu.php");
}

if (strtoupper(substr(PHP_OS, 0, 3)) !== 'WIN') {
    $log = &Log::singleton('syslog', LOG_LOCAL5, $logid);
} else {
    $opts = array('locking' => true, 'timeFormat' => '%Y/%m/%d %H:%M:%S');
    $log = &Log::singleton('file', '/secioss/var/log/auth.log', $logid, $opts);
}

define('USS_NML_401', "ユーザ情報を変更しました。");
define('USS_ERR_401', "ユーザ情報の変更に失敗しました。");
define('USS_ERR_402', "ログインIDは既に使用されています。");
define('USS_ERR_403', "不正な値です。");

define('STRLEN_MAX', 255);

$error = 0;
$message = '';
$tplfile = 'profile.tpl';
$lockfile = '/tmp/profile.lock';
$idhistoryattr = 'seciosssystemid';

$conf = parse_ini_file("../conf/config.ini", true);
if (empty($conf)) {
     $log->err(logformat("Can't read config.ini"));
     exit(1);
}

if (!isset($conf['password'])) {
     $log->err(logformat("Set password configuration"));
     exit(1);
}

$user = isset($_SERVER['REMOTE_USER']) ? $_SERVER['REMOTE_USER'] : null;
$loginid = '';
$mail = '';
$name = '';

$login = new AutoLogin($conf['password']['storage'], $conf['password']);
$storage = $login->storage;
$rc = $login->setUser($user, true);
if (PEAR::isError($rc)) {
    $log->crit(logformat("Setting profile failed: ". $rc->getMessage()));
    $error = 1;
    $message = USS_ERR_003;
} else {
    $name = $storage->get('cn');
    $kananame = $storage->get('cn;lang-ja;phonetic');
    $loginid = $storage->get($storage->options['loginattr']);
    $mail = $storage->get('mail');

    if (isset($_POST['loginid'])) {
        $oldloginid = $loginid;
        $loginid = $_POST['loginid'];
        $mail = $_POST['mail'];
        $rc = 0;
        if (!$loginid || strlen($loginid) > STRLEN_MAX) {
            $error = 1;
            $message = "ログインIDが".USS_ERR_403;
        }
        if (!$mail || strlen($mail) > STRLEN_MAX || !preg_match('/^[^@]+@[^@]+$/', $mail)) {
            $error = 1;
            $message = "メールアドレスが".USS_ERR_403;
        }

        if (!$error) {
            $lp = fopen($lockfile, 'w');
            flock($lp, LOCK_EX);

            $res = @ldap_search($storage->conn, $storage->options['basedn'], "(&(!(uid=$username))(|(uid=$loginid)($idhistoryattr=$loginid)))");
            if ($res == false) {
                $log->crit(logformat("Searching login id failed: ". ldap_error($login->conn)));
                $error = 1;
                $message = USS_ERR_003;
            } else if (ldap_count_entries($storage->conn, $res)) {
                $log->err(logformat("Login id is already used"));
                $error = 1;
                $message = USS_ERR_402;
            } else {
                $info = array('mail' => $mail);

                if ($loginid != $oldloginid) {
                    $info[$storage->options['loginattr']] = $loginid;
                    $idhistory = $storage->get($idhistoryattr);
                    if (is_array($idhistory)) {
                        $idhistory[] = $loginid;
                    } else if ($idhistory) {
                        $idhistory = array($idhistory, $loginid);
                    } else {
                        $idhistory = array($loginid);
                    }
                    $info[$idhistoryattr] = $idhistory;
                }

                if (!@ldap_mod_replace($storage->conn, $storage->id, $info)) {
                    $log->crit(logformat("Setting profile failed: ". ldap_error($storage->conn)));
                    $error = 1;
                    $message = USS_ERR_401;
                } else {
                    $log->notice(logformat("Setting profile suceeded"));
                    $message = USS_NML_401;
                }
            }

            flock($lp, LOCK_UN);
            fclose($lp);
        }
    }
}

$smarty = new Smarty();
$smarty->template_dir = 'templates';
$smarty->compile_dir = 'templates_c';

$smarty->assign('username', $user);
$smarty->assign('name', $name);
$smarty->assign('kananame', $kananame);
$smarty->assign('loginid', $loginid);
$smarty->assign('mail', $mail);
$smarty->assign('error', $error);
$smarty->assign('message', $message);
if (isset($menu)) {
    $allowed_menu = array();
    foreach ($menu as $link) {
        if (!isset($link['token']) || preg_match('/(|,)'.$link['token'].'(|,)/i', $_SESSION['token'])) {
            $allowed_menu[] = $link;
        }
    }
    $smarty->assign('menu', $allowed_menu);
}

$smarty->display($tplfile);
?>
