/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2008 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#ifndef AUREPORT_H
#define AUREPORT_H

#include <qdialog.h>
#include <qlayout.h>
#include <qcheckbox.h>
#include <qlabel.h> 
#include <qbuttongroup.h>
#include <qradiobutton.h>


class QLayout;
class QTextEdit;
class QLineEdit;
class QPushButton;
class AureportProcess;

class Aureport: public QDialog 
{
	Q_OBJECT
public:
	Aureport(QWidget *parent = 0, const char *name = 0);
	AureportProcess *aureport_process;
public slots:
signals:
protected:
private slots:
	void aureport_button_clicked();
public:
private:
	QLabel *aureportLabel;
	QButton *aureportButton;
	QButtonGroup *optionButtonGroup;
	QButtonGroup *option2ButtonGroup;
	QPushButton *closeButton;
	QTextEdit *textEdit1;
	QRadioButton *authenticationRadioButton;
	QRadioButton *avcmessagesRadioButton;
	QRadioButton *configRadioButton;
	QRadioButton *cryptoRadioButton;
	QRadioButton *eventsRadioButton;
	QRadioButton *filesRadioButton;
	QRadioButton *hostsRadioButton;
	QRadioButton *loginRadioButton;
	QRadioButton *modificationsRadioButton;
	QRadioButton *macRadioButton;
	QRadioButton *pidRadioButton;
	QRadioButton *responseRadioButton;
	QRadioButton *syscallRadioButton;
	QRadioButton *terminalRadioButton;
	QRadioButton *userRadioButton;
	QRadioButton *versionRadioButton;
	QRadioButton *executableRadioButton;

	QRadioButton *successFailedRadioButton;
	QRadioButton *successRadioButton;
	QRadioButton *failedRadioButton;

	QCheckBox *summaryCheckBox;
	QCheckBox *interpretCheckBox;
	QCheckBox *nodeCheckBox;

	QVBoxLayout *mainLayout;
	QHBoxLayout *firstLayout;
	QVBoxLayout *secondLayout;
	QVBoxLayout *thirdLayout;
	QHBoxLayout *fourthLayout;
	QVBoxLayout *middleLayout;
	QHBoxLayout *footLayout;

        QString aureport_str_pp;
        QString aureport_str_pp_str;
};

#endif
