/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2008 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include <qpushbutton.h>
#include <qprocess.h>

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <fstream>

#include "ausearch_process.h"

#include <iostream>
using namespace std;

//default constructor
AusearchProcess::AusearchProcess(QWidget *parent, const char *name): QDialog(parent, name)
{
	setCaption(tr("Ausearch Process"));
	textEdit1 = new QTextEdit(this);
	textEdit1->setPaletteBackgroundColor(QColor(250,180,200));
        textEdit1->resize( 600, 100 );

	closeButton = new QPushButton(tr("close"), this);
	//closing process button
	connect(closeButton, SIGNAL(clicked()), this, SLOT(close()));
	closeButton->setDefault(true);

	mainLayout = new QVBoxLayout(this);
	upperLayout = new QVBoxLayout;
	footLayout = new QHBoxLayout;
	
	mainLayout->setMargin(11);
	upperLayout->addWidget(textEdit1);

	footLayout->addStretch();
	footLayout->addWidget(closeButton);

	mainLayout->addLayout(upperLayout);
	mainLayout->addLayout(footLayout);
	resize(1000,600);
}

void AusearchProcess::ausearch_base_process(QString ausearch_str_pp_str)
{
        #define PWD_BUF 8600
        const char* ausearch_list_file="/root/segatex/ausearch/ausearch";
        ofstream os;
        os.open(ausearch_list_file);
        if(os){
                FILE *read_fp;
                #define SIZE_TMP 8600
                char buffer[SIZE_TMP];
                int chars_read;
                memset(buffer, '\0', sizeof(buffer));

                read_fp = popen(ausearch_str_pp_str, "r");
                if(read_fp != NULL){
                        chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        while(chars_read>0){
                                buffer[chars_read -1] = '\0';
                                //os << "Reading:-" << endl;
                                os << buffer;
                                chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
			}
			pclose(read_fp);
                }
        }
	os.close();
	readFromOutputFile();
}

//this slot should be called from above slot
void AusearchProcess::readFromOutputFile()
{
	/////////////////////////////////////////////////////////////
	//path = "./";
	path = "/root/segatex/ausearch";
	/////////////////////////////////////////////////////////////
	forward_slash = "/";
	dir.setPath(path);
	dir_name = dir.absPath();
	/////////////////////////////////////////////////////////////
	dir.setFilter( QDir::Files );
        dir.setSorting( QDir::Name );
	//files = dir.entryList(outputfile_str_common);
	files = dir.entryList("*ausearch");
	/////////////////////////////////////////////////////////////
	it_d = files.begin();
	int order_x;
	order_x = 1;
	//first clear it all, unless double the file.
	textEdit1->clear();
		while(it_d != files.end()){
			name = *it_d;
			file_interface_name = dir_name + forward_slash + name;
			QFile file( file_interface_name );
			/*
			QRegExp rx_nologin("nologin");
			QRegExp rx_shutdown("shutdown");
			QRegExp rx_halt("halt");
			QRegExp rx_news("news");
			QRegExp rx_false("false");
			QRegExp rx_sync("sync");
			*/
			if ( file.open( IO_ReadOnly ) ) {
				QTextStream stream( &file );
				////////////////////////////////////////////
				//int i,j,k,l,m,n;	
				if(order_x == 1)
					textEdit1->append("######### ausearch#########");
					textEdit1->append("");
				/*
				if(order_x == 2)
					textEdit1->append("#########user list#########");
					textEdit1->append("");
				if(order_x == 3)
					textEdit1->append("#########etc passwd list#########");
					textEdit1->append("");
				*/
				while ( !stream.atEnd() ) {
					line_analized = stream.readLine(); // line of text excluding '\n'
					//buttons.push_back(line_analized);
					/*
					i = line_analized.find( rx_nologin, 0);
					j = line_analized.find( rx_shutdown, 0);
					k = line_analized.find( rx_halt, 0);
					l = line_analized.find( rx_news, 0);
					m = line_analized.find( rx_false, 0);
					n = line_analized.find( rx_sync, 0);
					*/
                                        //if((i != -1)||(j != -1)||(k != -1)||(l != -1)||(m != -1)||(n != -1)){
						//do nothing
					//}else{
						textEdit1->append(line_analized);
					//}
				}
				file.close();
				order_x++;
				++it_d;
			}else{
				//do nothing
			}
		}
}
