/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2009 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include <qlayout.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <QLabel>

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "aureport.h"
#include "aureport_process.h"

#include <iostream>
using namespace std;

//default constructor
//Aureport::Aureport(QWidget *parent, const char *name): QWidget(parent, name)
Aureport::Aureport(QWidget *parent, const char *name): QDialog(parent, name)
{
	//setCaption(tr("Aureport"));
        aureportLabel = new QLabel(tr("Report about"),this);
        startdayLabel = new QLabel(tr("start-day(1/1/2009)"),this);
        starttimeLabel = new QLabel(tr("start-time"),this);
        enddayLabel = new QLabel(tr("end-day"),this);
        endtimeLabel = new QLabel(tr("end-time"),this);

        startdayEditLineEdit = new QLineEdit( this );
        startdayEditLineEdit->setText("this-year");
        startdayEditLineEdit->setPaletteBackgroundColor(QColor(200,200,140));

        starttimeEditLineEdit = new QLineEdit( this );
        starttimeEditLineEdit->setText("04:00:00");
        starttimeEditLineEdit->setPaletteBackgroundColor(QColor(200,200,140));

        enddayEditLineEdit = new QLineEdit( this );
        enddayEditLineEdit->setText("today");
        enddayEditLineEdit->setPaletteBackgroundColor(QColor(200,200,140));

        endtimeEditLineEdit = new QLineEdit( this );
        endtimeEditLineEdit->setText("");
        endtimeEditLineEdit->setPaletteBackgroundColor(QColor(200,200,140));

        summaryCheckBox = new QCheckBox(tr("Run the summary report of the main report"), this);
        //summaryCheckBox->setGeometry( 10, 10, 400, 20 );//--summary

        interpretCheckBox = new QCheckBox(tr("Interpret numeric entities into text"), this);
        //interpretCheckBox->setGeometry( 10, 10, 400, 20 );//-i
        //nodeCheckBox = new QCheckBox(tr(" Select events all nodes for processing in the reports."), this);
        //nodeCheckBox->setGeometry( 10, 10, 400, 20 );//--node

	//first,create group box 
        //optionButtonGroupBox = new QGroupBox(this);
	//optionButtonGroupBox->setFlat(true);

	aureportButton = new QPushButton(tr("See report"), this);
	aureportButton->setPaletteBackgroundColor(QColor(250,180,200));
	connect(aureportButton, SIGNAL(clicked()), this, SLOT(aureport_button_clicked()));

	closeButton = new QPushButton(tr("close"), this);
	//closing process button
	connect(closeButton, SIGNAL(clicked()), this, SLOT(close()));
	closeButton->setDefault(true);

	//thirdLayout->addWidget(nodeCheckBox);

	//footLayout->addStretch();

	//gridLayout = new QGridLayout;
	mainLayout = new QHBoxLayout;
	leftLayout = new QVBoxLayout;
	rightLayout = new QVBoxLayout;

	leftLayout->addWidget(aureportLabel);
	leftLayout->addWidget(createFirstExclusiveGroup());
	rightLayout->addWidget(createFirstExclusiveGroup2());
	rightLayout->addWidget(summaryCheckBox);
	rightLayout->addWidget(interpretCheckBox);
	rightLayout->addWidget(startdayLabel);
	rightLayout->addWidget(startdayEditLineEdit);
	rightLayout->addWidget(starttimeLabel);
	rightLayout->addWidget(starttimeEditLineEdit);
	rightLayout->addWidget(enddayLabel);
	rightLayout->addWidget(enddayEditLineEdit);
	rightLayout->addWidget(endtimeLabel);
	rightLayout->addWidget(endtimeEditLineEdit);
	rightLayout->addWidget(aureportButton);
	rightLayout->addWidget(closeButton);

	mainLayout->addLayout(leftLayout);
	mainLayout->addLayout(rightLayout);

	//setLayout(gridLayout);
	setLayout(mainLayout);
	setWindowTitle(tr("Aureport"));

	aureport_process = 0;
}
QGroupBox *Aureport::createFirstExclusiveGroup2()
{
        optionButtonGroupBox2 = new QGroupBox(tr("successful or failed events"));
        //option2ButtonGroup = new Q3ButtonGroup(this);
        //option2ButtonGroup = new QButtonGroup(this);
        successFailedRadioButton = new QRadioButton(tr("Both successful and failed events"));
        //successFailedRadioButton->setGeometry( 10, 10, 200, 20 );//no option
        successRadioButton = new QRadioButton(tr("Successful events"));
        //successRadioButton->setGeometry( 10, 30, 200, 20 );//--success
        failedRadioButton = new QRadioButton(tr("Failed events"));
        //failedRadioButton->setGeometry( 10, 50, 200, 20 );//--failed

        successFailedRadioButton->setChecked(true);

	vbox2 = new QVBoxLayout;
        vbox2->addWidget(successFailedRadioButton);
        vbox2->addWidget(successRadioButton);
        vbox2->addWidget(failedRadioButton);
	optionButtonGroupBox2->setLayout(vbox2);

	return optionButtonGroupBox2;
}

QGroupBox *Aureport::createFirstExclusiveGroup()
{
        optionButtonGroupBox = new QGroupBox(tr("Attemps"));
	//second,declear many buttons  
        authenticationRadioButton = new QRadioButton(tr("authentication attempts"));
        //authenticationRadioButton->setGeometry( 10, 10, 400, 20 );//-au
        avcmessagesRadioButton = new QRadioButton(tr("avc messages"));
        //avcmessagesRadioButton->setGeometry( 10, 30, 400, 40 );//-a
        configRadioButton = new QRadioButton(tr("config changes"));
        //configRadioButton->setGeometry( 10, 50, 400, 60 );//-c
        cryptoRadioButton = new QRadioButton(tr("crypto events"));
        //cryptoRadioButton->setGeometry( 10, 70, 400, 80 );//-cr
        eventsRadioButton = new QRadioButton(tr("events"));
        //eventsRadioButton->setGeometry( 10, 90, 400, 100 );//-e
        filesRadioButton = new QRadioButton(tr("files"));
        //filesRadioButton->setGeometry( 10, 110, 400, 120 );//-f
        hostsRadioButton = new QRadioButton(tr("hosts"));
        //hostsRadioButton->setGeometry( 10, 130, 400, 140 );//-h
        loginRadioButton = new QRadioButton(tr("logins"));
        //loginRadioButton->setGeometry( 10, 150, 400, 160 );//-l
        modificationsRadioButton = new QRadioButton(tr("account modifications"));
        //modificationsRadioButton->setGeometry( 10, 170, 400, 180 );//-m
        macRadioButton = new QRadioButton(tr("Mandatory Access Control(MAC)events"));
        //macRadioButton->setGeometry( 10, 190, 400, 200 );//-mac
        pidRadioButton = new QRadioButton(tr("processes"));
        //pidRadioButton->setGeometry( 10, 210, 400, 220 );//-p
        responseRadioButton = new QRadioButton(tr("responses to anomaly events"));
        //responseRadioButton->setGeometry( 10, 230, 400, 240 );//-r
        syscallRadioButton = new QRadioButton(tr("syscalls"));
        //syscallRadioButton->setGeometry( 10, 250, 400, 260 );//-s
        terminalRadioButton = new QRadioButton(tr("terminals"));
        //terminalRadioButton->setGeometry( 10, 270, 400, 280 );//-tm
        userRadioButton = new QRadioButton(tr("user"));
        //userRadioButton->setGeometry( 10, 290, 400, 300 );//-u
        executableRadioButton = new QRadioButton(tr("executables"));
        //executableRadioButton->setGeometry( 10, 310, 400, 320 );//-e
        //optionButtonGroup->resize( 400, 320 );

        authenticationRadioButton->setChecked(true);

	//third,add widget to vboxlayout
	vbox = new QVBoxLayout;
        vbox->addWidget(authenticationRadioButton);
        vbox->addWidget(avcmessagesRadioButton);
        vbox->addWidget(configRadioButton);
        vbox->addWidget(cryptoRadioButton);
        vbox->addWidget(eventsRadioButton);
        vbox->addWidget(filesRadioButton);
        vbox->addWidget(hostsRadioButton);
        vbox->addWidget(loginRadioButton);
        vbox->addWidget(modificationsRadioButton);
        vbox->addWidget(macRadioButton);
	vbox->addWidget(macRadioButton); 
	vbox->addWidget(pidRadioButton); 
	vbox->addWidget(responseRadioButton); 
	vbox->addWidget(syscallRadioButton); 
	vbox->addWidget(terminalRadioButton); 
	vbox->addWidget(userRadioButton); 
	vbox->addWidget(executableRadioButton); 
	//vbox->addStretch(1); 
	//fourth,layout vboxlayout to the group box
	optionButtonGroupBox->setLayout(vbox);
	
	return optionButtonGroupBox;
}

/*signal and slot should have same argument pattern so I had to pass to another slot*/
void Aureport::aureport_button_clicked()
{
	if(authenticationRadioButton->isChecked())
		aureport_str_pp = "aureport -au";
	if(avcmessagesRadioButton->isChecked())
		aureport_str_pp = "aureport -a";
	if(configRadioButton->isChecked())
		aureport_str_pp = "aureport -c";
	if(cryptoRadioButton->isChecked())
		aureport_str_pp = "aureport -cr";
	if(eventsRadioButton->isChecked())
		aureport_str_pp = "aureport -e";
	if(filesRadioButton->isChecked())
		aureport_str_pp = "aureport -f";
	if(hostsRadioButton->isChecked())
		aureport_str_pp = "aureport -h";
	if(loginRadioButton->isChecked())
		aureport_str_pp = "aureport -l";
	if(modificationsRadioButton->isChecked())
		aureport_str_pp = "aureport -m";
	if(macRadioButton->isChecked())
		aureport_str_pp = "aureport -ma";
	if(pidRadioButton->isChecked())
		aureport_str_pp = "aureport -p";
	if(responseRadioButton->isChecked())
		aureport_str_pp = "aureport -r";
	if(syscallRadioButton->isChecked())
		aureport_str_pp = "aureport -s";
	if(terminalRadioButton->isChecked())
		aureport_str_pp = "aureport -tm";
	if(userRadioButton->isChecked())
		aureport_str_pp = "aureport -u";
	if(executableRadioButton->isChecked())
		aureport_str_pp = "aureport -x";

	if(failedRadioButton->isChecked())
		aureport_str_pp = aureport_str_pp + " --failed";
	if(successRadioButton->isChecked())
		aureport_str_pp = aureport_str_pp + " --success";

	if(summaryCheckBox->isChecked())
		aureport_str_pp = aureport_str_pp + " --summary";
	if(interpretCheckBox->isChecked())
		aureport_str_pp = aureport_str_pp + " -i";
/*
	if(nodeCheckBox->isChecked())
		aureport_str_pp = aureport_str_pp + " --node";
*/

	aureport_str_pp_str = aureport_str_pp;

	//set start-day and start-time
	startdayEditLineEdit_str = startdayEditLineEdit->text();
	starttimeEditLineEdit_str = starttimeEditLineEdit->text();
	if(startdayEditLineEdit_str != ""){
		aureport_str_pp_str = aureport_str_pp_str + " --start " + startdayEditLineEdit_str + " " + starttimeEditLineEdit_str;
	}
	//set end-day and end-time
	enddayEditLineEdit_str = enddayEditLineEdit->text();
	endtimeEditLineEdit_str = endtimeEditLineEdit->text();
	if(enddayEditLineEdit_str != ""){
		aureport_str_pp_str = aureport_str_pp_str + " --end " + enddayEditLineEdit_str + " " + endtimeEditLineEdit_str;
	}

	aureport_process = new AureportProcess(this);
	//connect(aureport_process, SIGNAL(aureport_process_close_button_clicked()), this, SLOT(close()));
	connect(closeButton, SIGNAL(clicked()), aureport_process, SLOT(close()));
	aureport_process->setCaption(tr(aureport_str_pp_str));
	aureport_process->show();
	aureport_process->raise();
	aureport_process->setActiveWindow();

	aureport_process->aureport_base_process(aureport_str_pp_str);

}
