/**
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2009 Shintaro Fujiwara 
 *
 ** Copyright (C) 2008 Nokia Corporation and/or its subsidiary(-ies).
 ** Contact: Qt Software Information (qt-info@nokia.com)
 **
 ** This file is part of the example classes of the Qt Toolkit.
 **
 ** Commercial Usage
 ** Licensees holding valid Qt Commercial licenses may use this file in
 ** accordance with the Qt Commercial License Agreement provided with the
 ** Software or, alternatively, in accordance with the terms contained in
 ** a written agreement between you and Nokia.
 **
 **
 ** GNU General Public License Usage
 ** Alternatively, this file may be used under the terms of the GNU
 ** General Public License versions 2.0 or 3.0 as published by the Free
 ** Software Foundation and appearing in the file LICENSE.GPL included in
 ** the packaging of this file.  Please review the following information
 ** to ensure GNU General Public Licensing requirements will be met:
 ** http://www.fsf.org/licensing/licenses/info/GPLv2.html and
 ** http://www.gnu.org/copyleft/gpl.html.  In addition, as a special
 ** exception, Nokia gives you certain additional rights. These rights
 ** are described in the Nokia Qt GPL Exception version 1.3, included in
 ** the file GPL_EXCEPTION.txt in this package.
 **
 ** Qt for Windows(R) Licensees
 ** As a special exception, Nokia, as the sole copyright holder for Qt
 ** Designer, grants users of the Qt/Eclipse Integration plug-in the
 ** right for the Qt/Eclipse Integration to link to functionality
 ** provided by Qt Designer and its related libraries.
 **
 ** If you are unsure which license is appropriate for your use, please
 ** contact the sales department at qt-sales@nokia.com.
 **
 ****************************************************************************/
#ifndef MAINWINDOW_H
#define MAINWINDOW_H
#include <QMainWindow>
class MdiChild;
class QAction;
class QMenu;
class QMdiArea;
class QMdiSubWindow;
class SegatexState;
class QSignalMapper;
class QWorkspace;
class QLabel;
class Editor;
class BreakTe;
class BreakIf;
class SegatexState;
class SegatexApply;
class SegatexSetenforce;
class SegatexYum;
class SegatexYumProcess;
class SegatexAudit2allow;
class SegatexCore;
class SemoduleCoreProcess;
class SemanageCoreProcess;
class SemanageCoreLoginProcess;
class SemanageCoreFcontextProcess;
class SemanageCorePortProcess;
class SemanageCoreTranslationProcess;
class SemanageCoreBooleanProcess;
class SemanageCorePermissiveProcess;
class AutoRelabel;
class Policygeneration;
class Aureport;
class Ausearch;
class Useradd;
class Seeprocess;
class Restorecon;
class Downloader;
class Sqlrefpolicy;

class MainWindow : public QMainWindow
{
	Q_OBJECT
public:
	MainWindow();
public slots:
	void newFile();
	void openFile(const QString &fileName);
	void updateSegatexStateIndicator();
protected:
	void closeEvent(QCloseEvent *event);
private slots:
	//void newFile();
	void open();
	void save();
	void saveAs();
	void cut();
	void copy();
	void paste();
	void about();
	void updateMenus();
	void updateWindowMenu();
	MdiChild *createMdiChild();
	void switchLayoutDirection();
	void setActiveSubWindow(QWidget *window);
	void updateModIndicator();
	Editor *createEditor();
	Editor *activeEditor();
	void break_te();
	void break_if();
	void howtouse();
	void enforcing();
	void yum_selinux();
	void yum_selinux_process();
	void audit2allow();
	void segatex_core();
	void semodule_core_process();
	void semanage_core_process();
	void semanage_core_login_process();
	void semanage_core_fcontext_process();
	void semanage_core_port_process();
	void semanage_core_translation_process();
	void semanage_core_boolean_process();
	void semanage_core_permissive_process();
	void autorelabel_process();
	void policygeneration_process();
	void aureport();
	void ausearch();
	void useradd();
	void seeprocess();
	void restorecon();
	void downloader();
	void sqlrefpolicy();
private:
	void createActions();
	void createMenus();
	void createToolBars();
	void createStatusBar();
	void readSettings();
	void writeSettings();
	QLabel *readyLabel;
	QLabel *modLabel;
	QLabel *segatexStateLabel;
	QWorkspace *workspace;
	MdiChild *activeMdiChild();
	QMdiSubWindow *findMdiChild(const QString &fileName);
	QMdiArea *mdiArea;
	QSignalMapper *windowMapper;
	QMenu *fileMenu;
	QMenu *editMenu;
	QMenu *windowMenu;
	QMenu *helpMenu;
	//newly added
	QMenu *breakteMenu;
	QMenu *breakifMenu;
	QMenu *auditMenu;
	QMenu *policyMenu;
	QMenu *manageMenu;
	QMenu *semanageMenu;
	QMenu *relabelMenu;
	QMenu *downloaderMenu;
	QMenu *miscellaneousMenu;

	QToolBar *fileToolBar;
	QToolBar *editToolBar;
	QAction *newAct;
	QAction *openAct;
	QAction *saveAct;
	QAction *saveAsAct;
	QAction *exitAct;
	QAction *cutAct;
	QAction *copyAct;
	QAction *pasteAct;
	QAction *closeAct;
	QAction *closeAllAct;
	QAction *tileAct;
	QAction *cascadeAct;
	QAction *nextAct;
	QAction *previousAct;
	QAction *separatorAct;
	QAction *aboutAct;
	QAction *aboutQtAct;
	//newly added
	QAction *breakteAct;
	QAction *breakifAct;
	QAction *howtouseAct;
	QAction *enforcingAct;
	QAction *check_selinuxAct;
	QAction *default_policyAct;
	QAction *selinuxYumAct;
	QAction *selinuxYumProcessAct;
	QAction *audit2allowAct;
	QAction *segatex_coreAct;
	QAction *semodule_core_processAct;
	QAction *semanage_core_processAct;
	QAction *semanage_core_login_processAct;
	QAction *semanage_core_fcontext_processAct;
	QAction *semanage_core_port_processAct;
	QAction *semanage_core_translation_processAct;
	QAction *semanage_core_boolean_processAct;
	QAction *semanage_core_permissive_processAct;
	QAction *autorelabel_processAct;
	QAction *policygeneration_processAct;
	QAction *aureportAct;
	QAction *ausearchAct;
	QAction *useraddAct;
	QAction *seeprocessAct;
	QAction *restoreconAct;
	QAction *downloaderAct;
	QAction *sqlrefpolicyAct;

	QString selinux_policy;
	QString enabled_or_not_str;
	QString getenforce_str;

	BreakTe *breakte;
	BreakIf *breakif;
	SegatexState *segatex_state;
	SegatexApply *segatex_apply;
	SegatexSetenforce *segatex_apply_for_state;
	SegatexYum *selinux_yum;
	SegatexYumProcess *selinux_yum_process;
	SegatexAudit2allow *selinux_audit2allow;
	BreakTe *breakte_o;
	BreakIf *breakif_o;
	SegatexCore *segatex_core_o;
	SemoduleCoreProcess *semodule_core_process_o;
	SemanageCoreProcess *semanage_core_process_o;
	SemanageCoreLoginProcess *semanage_core_login_process_o;
	SemanageCoreFcontextProcess *semanage_core_fcontext_process_o;
	SemanageCorePortProcess *semanage_core_port_process_o;
	SemanageCoreTranslationProcess *semanage_core_translation_process_o;
	SemanageCoreBooleanProcess *semanage_core_boolean_process_o;
	SemanageCorePermissiveProcess *semanage_core_permissive_process_o;
	AutoRelabel *autorelabel_process_o;
	Policygeneration *policygeneration_process_o;
	Aureport *aureport_o;
	Ausearch *ausearch_o;
	Useradd *useradd_o;
	Seeprocess *seeprocess_o;
	Restorecon *restorecon_o;
	Downloader *downloader_o;
	Sqlrefpolicy *sqlrefpolicy_o;
};
#endif
