#include <sepol/sepol.h>
//########by me#######
#include <selinux/get_context_list.h>
//########end by me#######
#include <unistd.h>
#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>


void usage(char *progname)
{
	printf("usage:  %s seuser(system_u) \n", progname);
	exit(1);
}

int main(int argc, char **argv)
{
	security_context_t fromcon;
	security_context_t *list;
	fromcon = NULL;

	if(argc != 2)
		usage(argv[0]);

	if(get_ordered_context_list(argv[1],fromcon,&list) < 0) {
		fprintf(stderr, "%s is not a valid seuser \n", argv[1]);
		exit(1);
	}
	while(**&list){
		printf("%s's context is %s \n", argv[1],**&list);
		list++;
	}
	freecon(*list);
	exit(0);
}
