/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2010 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include <qlayout.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <QLabel>

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "ausearch.h"
#include "ausearch_process.h"

#include <iostream>
using namespace std;

//default constructor
Ausearch::Ausearch(QWidget *parent, const char *name): QDialog(parent, name)
{
	//setCaption(tr("Ausearch"));
	ausearchLabel = new QLabel(tr("Search about"),this);
	startdayLabel = new QLabel(tr("start-day(1/1/2010)"),this);
	starttimeLabel = new QLabel(tr("start-time"),this);
	enddayLabel = new QLabel(tr("end-day"),this);
	endtimeLabel = new QLabel(tr("end-time"),this);

	ausearchEditLineEdit = new QLineEdit( this );
        ausearchEditLineEdit->setText("");
        ausearchEditLineEdit->setPaletteBackgroundColor(QColor(200,200,140));

	startdayEditLineEdit = new QLineEdit( this );
        startdayEditLineEdit->setText("this-year");
        startdayEditLineEdit->setPaletteBackgroundColor(QColor(200,200,140));

	starttimeEditLineEdit = new QLineEdit( this );
        starttimeEditLineEdit->setText("04:00:00");
        starttimeEditLineEdit->setPaletteBackgroundColor(QColor(200,200,140));

	enddayEditLineEdit = new QLineEdit( this );
        enddayEditLineEdit->setText("today");
        enddayEditLineEdit->setPaletteBackgroundColor(QColor(200,200,140));

	endtimeEditLineEdit = new QLineEdit( this );
        endtimeEditLineEdit->setText("");
        endtimeEditLineEdit->setPaletteBackgroundColor(QColor(200,200,140));

	interpretCheckBox = new QCheckBox(tr("Interpret numeric entities into text"), this);
	ausearchButton = new QPushButton(tr("Search"), this);
	ausearchButton->setPaletteBackgroundColor(QColor(250,180,200));
	connect(ausearchButton, SIGNAL(clicked()), this, SLOT(ausearch_button_clicked()));

	closeButton = new QPushButton(tr("close"), this);
	//closing process button
	connect(closeButton, SIGNAL(clicked()), this, SLOT(close()));
	closeButton->setDefault(true);

	mainLayout = new QHBoxLayout;
	rightLayout = new QVBoxLayout;
	leftLayout = new QVBoxLayout;


	leftLayout->addWidget(ausearchLabel);
	leftLayout->addWidget(createFirstExclusiveGroup());
	leftLayout->addWidget(ausearchEditLineEdit);

	rightLayout->addWidget(startdayLabel);
	rightLayout->addWidget(startdayEditLineEdit);
	rightLayout->addWidget(starttimeLabel);
	rightLayout->addWidget(starttimeEditLineEdit);
	//rightLayout->addStretch();

	rightLayout->addWidget(enddayLabel);
	rightLayout->addWidget(enddayEditLineEdit);
	rightLayout->addWidget(endtimeLabel);
	rightLayout->addWidget(endtimeEditLineEdit);

	rightLayout->addWidget(interpretCheckBox);

	rightLayout->addWidget(ausearchButton);

	rightLayout->addWidget(closeButton);

	mainLayout->addLayout(leftLayout);
	mainLayout->addLayout(rightLayout);

	setLayout(mainLayout);
	setWindowTitle(tr("Ausearch"));

	ausearch_process = 0;
}

QGroupBox *Ausearch::createFirstExclusiveGroup()
{
        //optionButtonGroup = new Q3ButtonGroup(this);
        optionButtonGroupBox = new QGroupBox(tr("test"));
        //optionButtonGroup->resize( 650, 350 );
        eventRadioButton = new QRadioButton(tr("events (audit-event-id)"));
        //eventRadioButton->setGeometry( 10, 10, 400, 20 );//-a
        commnameRadioButton = new QRadioButton(tr("come name (comm-name)"));
        //commnameRadioButton->setGeometry( 10, 30, 400, 20 );//-c
        filenameRadioButton = new QRadioButton(tr("filename (file-name)"));
        //filenameRadioButton->setGeometry( 10, 50, 400, 20 );//-f
        allgroupidRadioButton = new QRadioButton(tr("group ID (all-group-id)"));
        //allgroupidRadioButton->setGeometry( 10, 70, 400, 20 );//-ga
        effectivegroupidRadioButton = new QRadioButton(tr("effective group ID (effective-group-id)"));
        //effectivegroupidRadioButton->setGeometry( 10, 90, 400, 20 );//-ga
        groupidRadioButton = new QRadioButton(tr("group ID (group-id)"));
        //groupidRadioButton->setGeometry( 10, 110, 400, 20 );//-ga
        helpRadioButton = new QRadioButton(tr("help"));
        //helpRadioButton->setGeometry( 10, 130, 400, 20 );//-ga
        hostnameRadioButton = new QRadioButton(tr("host name (host-name)"));
        //hostnameRadioButton->setGeometry( 10, 150, 400, 20 );//-ga
        keystringRadioButton = new QRadioButton(tr("key string (key-string)"));
        //keystringRadioButton->setGeometry( 10, 170, 400, 20 );//-ga
        nodenameRadioButton = new QRadioButton(tr("node (node-name)"));
        //nodenameRadioButton->setGeometry( 10, 190, 400, 20 );//-ga
        objectRadioButton = new QRadioButton(tr("object (SE-Linux-context-string)"));
        //objectRadioButton->setGeometry( 10, 210, 400, 20 );//-ga
        inputRadioButton = new QRadioButton(tr("input (file-name)"));
        //inputRadioButton->setGeometry( 10, 230, 400, 20 );//-ga
        processidRadioButton = new QRadioButton(tr("pid (process-id)"));
        //processidRadioButton->setGeometry( 10, 250, 400, 20 );//-ga
        syscallRadioButton = new QRadioButton(tr("syscall (syscall-name-or-value)"));
        //syscallRadioButton->setGeometry( 10, 270, 400, 20 );//-ga

	eventRadioButton->setChecked(true);

	vbox = new QVBoxLayout;
	vbox->addWidget(eventRadioButton);
	vbox->addWidget(commnameRadioButton);
	vbox->addWidget(filenameRadioButton);
	vbox->addWidget(allgroupidRadioButton);
	vbox->addWidget(effectivegroupidRadioButton);
	vbox->addWidget(groupidRadioButton);
	vbox->addWidget(helpRadioButton);
	vbox->addWidget(hostnameRadioButton);
	vbox->addWidget(keystringRadioButton);
	vbox->addWidget(nodenameRadioButton);
	vbox->addWidget(objectRadioButton);
	vbox->addWidget(inputRadioButton);
	vbox->addWidget(processidRadioButton);
	vbox->addWidget(syscallRadioButton);

	optionButtonGroupBox->setLayout(vbox);

	return optionButtonGroupBox;
}

/*signal and slot should have same argument pattern so I had to pass to another slot*/
void Ausearch::ausearch_button_clicked()
{
        if(eventRadioButton->isChecked()){
		ausearchEditLineEdit_str = ausearchEditLineEdit->text();
                ausearch_str_pp_str = "ausearch -a " + ausearchEditLineEdit_str;
	}
        if(commnameRadioButton->isChecked()){
		ausearchEditLineEdit_str = ausearchEditLineEdit->text();
                ausearch_str_pp_str = "ausearch --comm " + ausearchEditLineEdit_str;
	}
        if(filenameRadioButton->isChecked()){
		ausearchEditLineEdit_str = ausearchEditLineEdit->text();
                ausearch_str_pp_str = "ausearch --file " + ausearchEditLineEdit_str;
	}
        if(allgroupidRadioButton->isChecked()){
		ausearchEditLineEdit_str = ausearchEditLineEdit->text();
                ausearch_str_pp_str = "ausearch --gid-all " + ausearchEditLineEdit_str;
	}
        if(effectivegroupidRadioButton->isChecked()){
		ausearchEditLineEdit_str = ausearchEditLineEdit->text();
                ausearch_str_pp_str = "ausearch --gid-effective " + ausearchEditLineEdit_str;
	}
        if(groupidRadioButton->isChecked()){
		ausearchEditLineEdit_str = ausearchEditLineEdit->text();
                ausearch_str_pp_str = "ausearch --gid " + ausearchEditLineEdit_str;
	}
        if(helpRadioButton->isChecked()){
		ausearchEditLineEdit_str = ausearchEditLineEdit->text();
                ausearch_str_pp_str = "ausearch --help";
	}
        if(hostnameRadioButton->isChecked()){
		ausearchEditLineEdit_str = ausearchEditLineEdit->text();
                ausearch_str_pp_str = "ausearch --host " + ausearchEditLineEdit_str;
	}
        if(keystringRadioButton->isChecked()){
		ausearchEditLineEdit_str = ausearchEditLineEdit->text();
                ausearch_str_pp_str = "ausearch --key " + ausearchEditLineEdit_str;
	}
        if(nodenameRadioButton->isChecked()){
		ausearchEditLineEdit_str = ausearchEditLineEdit->text();
                ausearch_str_pp_str = "ausearch --node " + ausearchEditLineEdit_str;
	}
        if(objectRadioButton->isChecked()){
		ausearchEditLineEdit_str = ausearchEditLineEdit->text();
                ausearch_str_pp_str = "ausearch --object " + ausearchEditLineEdit_str;
	}
        if(inputRadioButton->isChecked()){
		ausearchEditLineEdit_str = ausearchEditLineEdit->text();
                ausearch_str_pp_str = "ausearch --input " + ausearchEditLineEdit_str;
	}
        if(processidRadioButton->isChecked()){
		ausearchEditLineEdit_str = ausearchEditLineEdit->text();
                ausearch_str_pp_str = "ausearch --pid " + ausearchEditLineEdit_str;
	}
        if(syscallRadioButton->isChecked()){
		ausearchEditLineEdit_str = ausearchEditLineEdit->text();
                ausearch_str_pp_str = "ausearch --syscall " + ausearchEditLineEdit_str;
	}

	//for checkbox
        if(interpretCheckBox->isChecked()){
                ausearch_str_pp_str = ausearch_str_pp_str + " -i";
	}
	//set start-day and start-time
	startdayEditLineEdit_str = startdayEditLineEdit->text();
	starttimeEditLineEdit_str = starttimeEditLineEdit->text();
        if(startdayEditLineEdit_str != ""){
		ausearch_str_pp_str = ausearch_str_pp_str + " --start " + startdayEditLineEdit_str + " " + starttimeEditLineEdit_str;
	}
	//set end-day and end-time
	enddayEditLineEdit_str = enddayEditLineEdit->text();
	endtimeEditLineEdit_str = endtimeEditLineEdit->text();
        if(enddayEditLineEdit_str != ""){
		ausearch_str_pp_str = ausearch_str_pp_str + " --end " + enddayEditLineEdit_str + " " + endtimeEditLineEdit_str;
	}

	ausearch_process = new AusearchProcess(this);
	//connect(ausearch_process, SIGNAL(ausearch_process_close_button_clicked()), this, SLOT(close()));
	connect(closeButton, SIGNAL(clicked()), ausearch_process, SLOT(close()));
	ausearch_process->setCaption(tr(ausearch_str_pp_str));
	ausearch_process->show();
	ausearch_process->raise();
	ausearch_process->setActiveWindow();

	ausearch_process->ausearch_base_process(ausearch_str_pp_str);

}
